/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.backends.cassandra;

import org.apache.james.util.Host;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.testcontainers.containers.GenericContainer;


public class DockerCassandraRule implements TestRule {

    @Override
    public Statement apply(Statement base, Description description) {
        return base;
    }

    public void start() {
        DockerCassandraSingleton.singleton.start();
    }

    public void stop() {

    }

    public Host getHost() {
        return DockerCassandraSingleton.singleton.getHost();
    }
    
    public String getIp() {
        return DockerCassandraSingleton.singleton.getIp();
    }

    public int getBindingPort() {
        return DockerCassandraSingleton.singleton.getBindingPort();
    }

    public GenericContainer<?> getRawContainer() {
        return DockerCassandraSingleton.singleton.getRawContainer();
    }

    public void pause() {
        DockerCassandraSingleton.singleton.pause();
    }

    public void unpause() {
        DockerCassandraSingleton.singleton.unpause();
    }

}
