/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jcr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.jcr.model.JCRUser;
import org.apache.james.user.lib.AbstractUsersRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class JCRUsersRepository
extends AbstractUsersRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(JCRUsersRepository.class);
    private static final String PASSWD_PROPERTY = "passwd";
    private static final String USERNAME_PROPERTY = "username";
    private static final String USERS_PATH = "users";
    private Repository repository;
    private SimpleCredentials creds;
    private String workspace;

    @Inject
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
        this.workspace = config.getString("workspace", null);
        String username = config.getString(USERNAME_PROPERTY, null);
        String password = config.getString("password", null);
        if (username != null && password != null) {
            this.creds = new SimpleCredentials(username, password.toCharArray());
        }
    }

    protected String toSafeName(String key) {
        return ISO9075.encode((String)Text.escapeIllegalJcrChars((String)key));
    }

    private Session login() throws RepositoryException {
        return this.repository.login((Credentials)this.creds, this.workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getUserByName(String username) {
        JCRUser user;
        try {
            Session session = this.login();
            try {
                String name = this.toSafeName(username);
                String path = "users/" + name;
                Node rootNode = session.getRootNode();
                try {
                    Node node = rootNode.getNode(path);
                    user = new JCRUser(node.getProperty(USERNAME_PROPERTY).getString(), node.getProperty(PASSWD_PROPERTY).getString());
                }
                catch (PathNotFoundException e) {
                    user = null;
                }
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            LOGGER.info("Failed to add user: {}", (Object)username, (Object)e);
            user = null;
        }
        return user;
    }

    public String getRealName(String name) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUser(User user) throws UsersRepositoryException {
        if (user != null && user instanceof JCRUser) {
            JCRUser jcrUser = (JCRUser)user;
            String userName = jcrUser.getUserName();
            try {
                Session session = this.login();
                try {
                    String name = this.toSafeName(userName);
                    String path = "users/" + name;
                    Node rootNode = session.getRootNode();
                    try {
                        String hashedSaltedPassword = jcrUser.getHashedSaltedPassword();
                        rootNode.getNode(path).setProperty(PASSWD_PROPERTY, hashedSaltedPassword);
                        session.save();
                    }
                    catch (PathNotFoundException e) {
                        LOGGER.debug("User not found");
                        throw new UsersRepositoryException("User " + user.getUserName() + " not exist");
                    }
                }
                finally {
                    session.logout();
                }
            }
            catch (RepositoryException e) {
                LOGGER.info("Failed to add user: {}", (Object)userName, (Object)e);
                throw new UsersRepositoryException("Failed to add user: " + userName, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String username) throws UsersRepositoryException {
        try {
            Session session = this.login();
            try {
                String name = this.toSafeName(username);
                String path = "users/" + name;
                try {
                    session.getRootNode().getNode(path).remove();
                    session.save();
                }
                catch (PathNotFoundException e) {
                    throw new UsersRepositoryException("User " + username + " not exists");
                }
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            LOGGER.info("Failed to remove user: {}", (Object)username, (Object)e);
            throw new UsersRepositoryException("Failed to remove user: " + username, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) throws UsersRepositoryException {
        block6: {
            boolean bl;
            Session session = this.login();
            try {
                Node rootNode = session.getRootNode();
                String path = "users/" + this.toSafeName(name.toLowerCase(Locale.US));
                rootNode.getNode(path);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    session.logout();
                    throw throwable;
                }
                catch (PathNotFoundException e) {
                    LOGGER.debug("User not found: {}", (Object)name, (Object)e);
                    break block6;
                }
                catch (RepositoryException e) {
                    throw new UsersRepositoryException("Failed to search for user: " + name, (Throwable)e);
                }
            }
            session.logout();
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(String username, String password) throws UsersRepositoryException {
        try {
            Session session = this.login();
            try {
                String current;
                String name = this.toSafeName(username);
                String path = "users/" + name;
                Node rootNode = session.getRootNode();
                try {
                    Node node = rootNode.getNode(path);
                    current = node.getProperty(PASSWD_PROPERTY).getString();
                    if (current == null || current.equals("")) {
                        boolean bl = password == null || password.equals("");
                        return bl;
                    }
                }
                catch (PathNotFoundException e) {
                    LOGGER.debug("User not found");
                    boolean bl = false;
                    return bl;
                }
                String hashPassword = JCRUser.hashPassword(username, password);
                boolean bl = current.equals(hashPassword);
                return bl;
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            LOGGER.info("Failed to search user: {}", (Object)username, (Object)e);
            throw new UsersRepositoryException("Failed to search for user: " + username, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int countUsers() throws UsersRepositoryException {
        try {
            Session session = this.login();
            try {
                Node rootNode = session.getRootNode();
                try {
                    Node node = rootNode.getNode(USERS_PATH);
                    NodeIterator it = node.getNodes();
                    int n = (int)it.getSize();
                    return n;
                }
                catch (PathNotFoundException e) {
                    int n2 = 0;
                    session.logout();
                    return n2;
                }
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e2) {
            LOGGER.info("Failed to count user", (Throwable)e2);
            throw new UsersRepositoryException("Failed to count user", (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> list() throws UsersRepositoryException {
        ArrayList<String> userNames = new ArrayList<String>();
        try {
            Session session = this.login();
            try {
                Node rootNode = session.getRootNode();
                try {
                    Node baseNode = rootNode.getNode(USERS_PATH);
                    NodeIterator it = baseNode.getNodes();
                    while (it.hasNext()) {
                        Node node = it.nextNode();
                        try {
                            String userName = node.getProperty(USERNAME_PROPERTY).getString();
                            userNames.add(userName);
                        }
                        catch (PathNotFoundException e) {
                            LOGGER.info("Node missing user name. Ignoring.");
                        }
                    }
                }
                catch (PathNotFoundException e) {
                    LOGGER.info("Path not found. Forgotten to setup the repository?");
                }
            }
            finally {
                session.logout();
            }
        }
        catch (RepositoryException e) {
            LOGGER.info("Failed to list users", (Throwable)e);
            throw new UsersRepositoryException("Failed to list users", (Throwable)e);
        }
        return userNames.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAddUser(String username, String password) throws UsersRepositoryException {
        String lowerCasedUsername = username.toLowerCase(Locale.US);
        if (this.contains(lowerCasedUsername)) {
            throw new UsersRepositoryException(lowerCasedUsername + " already exists.");
        }
        try {
            Session session = this.login();
            try {
                String name = this.toSafeName(lowerCasedUsername);
                String path = "users/" + name;
                Node rootNode = session.getRootNode();
                try {
                    rootNode.getNode(path);
                    LOGGER.info("User already exists");
                    throw new UsersRepositoryException("User " + lowerCasedUsername + " already exists");
                }
                catch (PathNotFoundException pathNotFoundException) {
                    Node parent;
                    try {
                        parent = rootNode.getNode(USERS_PATH);
                    }
                    catch (PathNotFoundException e) {
                        parent = rootNode.addNode(USERS_PATH);
                    }
                    Node node = parent.addNode(name);
                    node.setProperty(USERNAME_PROPERTY, lowerCasedUsername);
                    String hashedPassword = password == null ? "" : JCRUser.hashPassword(lowerCasedUsername, password);
                    node.setProperty(PASSWD_PROPERTY, hashedPassword);
                    session.save();
                    session.logout();
                }
            }
            catch (Throwable throwable) {
                session.logout();
                throw throwable;
            }
        }
        catch (RepositoryException e) {
            LOGGER.info("Failed to add user: {}", (Object)lowerCasedUsername, (Object)e);
            throw new UsersRepositoryException("Failed to add user: " + lowerCasedUsername, (Throwable)e);
        }
    }
}

