/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.Subscriber;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.eventstore.EventStoreFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBus.class);
    private final EventStore eventStore;
    private final Set<Subscriber> subscribers;

    @Inject
    public EventBus(EventStore eventStore, Set<Subscriber> subscribers) {
        this.eventStore = eventStore;
        this.subscribers = ImmutableSet.copyOf(subscribers);
    }

    public void publish(List<Event> events) throws EventStoreFailedException {
        this.eventStore.appendAll(events);
        events.stream().flatMap(event -> this.subscribers.stream().map(subscriber -> Pair.of((Object)event, (Object)subscriber))).forEach(this::handle);
    }

    private void handle(Pair<Event, Subscriber> pair) {
        Subscriber subscriber = (Subscriber)pair.getRight();
        Event event = (Event)pair.getLeft();
        try {
            subscriber.handle(event);
        }
        catch (Exception e) {
            LOGGER.error("Error while calling {} for {}", new Object[]{subscriber, event, e});
        }
    }
}

