/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr.mail.model;

import com.github.steveash.guavate.Guavate;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.mail.Flags;
import javax.mail.internet.SharedInputStream;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jcr.JCRId;
import org.apache.james.mailbox.jcr.JCRImapConstants;
import org.apache.james.mailbox.jcr.Persistent;
import org.apache.james.mailbox.jcr.mail.model.JCRProperty;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.ComposedMessageIdWithMetaData;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageAttachment;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.mail.model.FlagsFactory;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.mail.model.Property;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.mail.model.impl.PropertyBuilder;
import org.apache.james.mailbox.store.search.comparator.UidComparator;
import org.apache.james.mime4j.MimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRMailboxMessage
implements MailboxMessage,
JCRImapConstants,
Persistent {
    private static final Logger LOGGER = LoggerFactory.getLogger(JCRMailboxMessage.class);
    private static final Comparator<MailboxMessage> MESSAGE_UID_COMPARATOR = new UidComparator();
    private Node node;
    private SharedInputStream content;
    private String mediaType;
    private Long textualLineCount;
    private String subType;
    private List<JCRProperty> properties;
    private int bodyStartOctet;
    private JCRId mailboxUUID;
    private MessageUid uid;
    private MessageId messageId;
    private Date internalDate;
    private long size;
    private boolean answered;
    private boolean deleted;
    private boolean draft;
    private boolean flagged;
    private boolean recent;
    private boolean seen;
    private String[] userFlags;
    private long modSeq;
    private static final String TOSTRING_SEPARATOR = " ";
    public static final String MAILBOX_UUID_PROPERTY = "jamesMailbox:mailboxUUID";
    public static final String UID_PROPERTY = "jamesMailbox:uid";
    public static final String SIZE_PROPERTY = "jamesMailbox:size";
    public static final String ANSWERED_PROPERTY = "jamesMailbox:answered";
    public static final String DELETED_PROPERTY = "jamesMailbox:deleted";
    public static final String DRAFT_PROPERTY = "jamesMailbox:draft";
    public static final String FLAGGED_PROPERTY = "jamesMailbox:flagged";
    public static final String USERFLAGS_PROPERTY = "jamesMailbox:userFlags";
    public static final String RECENT_PROPERTY = "jamesMailbox:recent";
    public static final String SEEN_PROPERTY = "jamesMailbox:seen";
    public static final String INTERNAL_DATE_PROPERTY = "jamesMailbox:internalDate";
    public static final String BODY_START_OCTET_PROPERTY = "jamesMailbox:messageBodyStartOctet";
    public static final String HEADER_NODE_TYPE = "jamesMailbox:messageHeader";
    public static final String PROPERTY_NODE_TYPE = "jamesMailbox:messageProperty";
    public static final String TEXTUAL_LINE_COUNT_PROPERTY = "jamesMailbox:messageTextualLineCount";
    public static final String SUBTYPE_PROPERTY = "jamesMailbox:messageSubType";
    public static final String MODSEQ_PROPERTY = "jamesMailbox:modSeq";

    public JCRMailboxMessage(Node node, Logger logger) {
        this.node = node;
    }

    public JCRMailboxMessage(JCRId mailboxUUID, MessageId messageId, Date internalDate, int size, Flags flags, SharedInputStream content, int bodyStartOctet, PropertyBuilder propertyBuilder) {
        this.mailboxUUID = mailboxUUID;
        this.messageId = messageId;
        this.internalDate = internalDate;
        this.size = size;
        this.setFlags(flags);
        this.content = content;
        this.bodyStartOctet = bodyStartOctet;
        this.textualLineCount = propertyBuilder.getTextualLineCount();
        this.mediaType = propertyBuilder.getMediaType();
        this.subType = propertyBuilder.getSubType();
        List properties = propertyBuilder.toProperties();
        this.properties = new ArrayList<JCRProperty>(properties.size());
        for (Property property : properties) {
            this.properties.add(new JCRProperty(property));
        }
    }

    public JCRMailboxMessage(JCRId mailboxUUID, MessageUid uid, MessageId messageId, long modSeq, JCRMailboxMessage message) throws MailboxException {
        this.mailboxUUID = mailboxUUID;
        this.messageId = messageId;
        this.internalDate = message.getInternalDate();
        this.size = message.getFullContentOctets();
        this.setFlags(message.createFlags());
        this.uid = uid;
        this.modSeq = modSeq;
        try {
            this.content = new SharedByteArrayInputStream(IOUtils.toByteArray((InputStream)message.getFullContent()));
        }
        catch (IOException e) {
            throw new MailboxException("Unable to parse message", (Throwable)e);
        }
        this.bodyStartOctet = (int)(message.getFullContentOctets() - message.getBodyOctets());
        PropertyBuilder pBuilder = new PropertyBuilder(message.getProperties());
        this.textualLineCount = message.getTextualLineCount();
        this.mediaType = message.getMediaType();
        this.subType = message.getSubType();
        List properties = pBuilder.toProperties();
        this.properties = new ArrayList<JCRProperty>(properties.size());
        for (Property property : properties) {
            this.properties.add(new JCRProperty(property));
        }
    }

    public ComposedMessageIdWithMetaData getComposedMessageIdWithMetaData() {
        return ComposedMessageIdWithMetaData.builder().modSeq(this.modSeq).flags(this.createFlags()).composedMessageId(new ComposedMessageId((MailboxId)this.getMailboxId(), this.getMessageId(), this.uid)).build();
    }

    public long getFullContentOctets() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(SIZE_PROPERTY).getLong();
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to retrieve property jamesMailbox:size", (Throwable)e);
                return 0L;
            }
        }
        return this.size;
    }

    public String getMediaType() {
        if (this.isPersistent()) {
            try {
                return this.node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to retrieve node jcr:mimeType", (Throwable)e);
                return null;
            }
        }
        return this.mediaType;
    }

    public List<Property> getProperties() {
        if (this.isPersistent()) {
            try {
                ArrayList<Property> properties = new ArrayList<Property>();
                NodeIterator nodeIt = this.node.getNodes("messageProperty");
                while (nodeIt.hasNext()) {
                    properties.add(new JCRProperty(nodeIt.nextNode()));
                }
                return properties;
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to retrieve nodes messageProperty", (Throwable)e);
            }
        }
        return new ArrayList<Property>(this.properties);
    }

    public String getSubType() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(SUBTYPE_PROPERTY).getString();
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to retrieve node jamesMailbox:messageSubType", (Throwable)e);
                return null;
            }
        }
        return this.subType;
    }

    public long getBodyOctets() {
        return this.getFullContentOctets() - (long)this.getBodyStartOctet();
    }

    public Long getTextualLineCount() {
        if (this.isPersistent()) {
            try {
                if (this.node.hasProperty(TEXTUAL_LINE_COUNT_PROPERTY)) {
                    return this.node.getProperty(TEXTUAL_LINE_COUNT_PROPERTY).getLong();
                }
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to retrieve property jamesMailbox:messageTextualLineCount", (Throwable)e);
            }
            return null;
        }
        return this.textualLineCount;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public boolean isPersistent() {
        return this.node != null;
    }

    public String getUUID() {
        if (this.isPersistent()) {
            try {
                return this.node.getIdentifier();
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access UUID", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void merge(Node node) throws RepositoryException, IOException {
        node.setProperty(ANSWERED_PROPERTY, this.isAnswered());
        node.setProperty(DELETED_PROPERTY, this.isDeleted());
        node.setProperty(DRAFT_PROPERTY, this.isDraft());
        node.setProperty(FLAGGED_PROPERTY, this.isFlagged());
        node.setProperty(RECENT_PROPERTY, this.isRecent());
        node.setProperty(SEEN_PROPERTY, this.isSeen());
        node.setProperty(USERFLAGS_PROPERTY, this.createFlags().getUserFlags());
        if (!this.isPersistent()) {
            node.setProperty(SIZE_PROPERTY, this.getFullContentOctets());
            node.setProperty(MAILBOX_UUID_PROPERTY, this.getMailboxId().serialize());
            node.setProperty(UID_PROPERTY, this.getUid().asLong());
            node.setProperty(MODSEQ_PROPERTY, this.getModSeq());
            if (this.getInternalDate() == null) {
                this.internalDate = new Date();
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.getInternalDate());
            node.setProperty(INTERNAL_DATE_PROPERTY, cal);
            Node contentNode = JcrUtils.getOrAddNode((Node)node, (String)"jcr:content", (String)"nt:resource");
            Binary binaryContent = contentNode.getSession().getValueFactory().createBinary(this.getFullContent());
            contentNode.setProperty("jcr:data", binaryContent);
            contentNode.setProperty("jcr:mimeType", this.getMediaType());
            if (this.getTextualLineCount() != null) {
                node.setProperty(TEXTUAL_LINE_COUNT_PROPERTY, this.getTextualLineCount().longValue());
            }
            node.setProperty(SUBTYPE_PROPERTY, this.getSubType());
            node.setProperty(BODY_START_OCTET_PROPERTY, (long)this.getBodyStartOctet());
            List<Property> currentProperties = this.getProperties();
            List newProperties = (List)currentProperties.stream().map(JCRProperty::new).collect(Guavate.toImmutableList());
            NodeIterator iterator = node.getNodes("messageProperty");
            while (iterator.hasNext()) {
                iterator.nextNode().remove();
            }
            for (Property newProperty : newProperties) {
                JCRProperty prop = (JCRProperty)newProperty;
                Node propNode = node.addNode("messageProperty", "nt:unstructured");
                propNode.addMixin(PROPERTY_NODE_TYPE);
                prop.merge(propNode);
            }
        }
        this.node = node;
    }

    private int getBodyStartOctet() {
        if (this.isPersistent()) {
            try {
                return (int)this.node.getProperty(BODY_START_OCTET_PROPERTY).getLong();
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to retrieve property jamesMailbox:messageTextualLineCount", (Throwable)e);
                return 0;
            }
        }
        return this.bodyStartOctet;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JCRMailboxMessage other = (JCRMailboxMessage)obj;
        if (this.getUUID() != null ? !this.getUUID().equals(other.getUUID()) : other.getUUID() != null) {
            return false;
        }
        if (this.getMailboxId() != null ? !this.getMailboxId().equals(other.getMailboxId()) : other.getMailboxId() != null) {
            return false;
        }
        return !(this.getId() != null ? !this.getId().equals(other.getId()) : other.getId() != null);
    }

    public MessageId getMessageId() {
        return this.messageId;
    }

    public Date getInternalDate() {
        if (this.isPersistent()) {
            try {
                if (this.node.hasProperty(INTERNAL_DATE_PROPERTY)) {
                    return this.node.getProperty(INTERNAL_DATE_PROPERTY).getDate().getTime();
                }
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:flagged", (Throwable)e);
            }
            return null;
        }
        return this.internalDate;
    }

    public JCRId getMailboxId() {
        if (this.isPersistent()) {
            try {
                return JCRId.of(this.node.getProperty(MAILBOX_UUID_PROPERTY).getString());
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:mailboxUUID", (Throwable)e);
            }
        }
        return this.mailboxUUID;
    }

    public MessageUid getUid() {
        if (this.isPersistent()) {
            try {
                return MessageUid.of((long)this.node.getProperty(UID_PROPERTY).getLong());
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:uid", (Throwable)e);
                return MessageUid.MIN_VALUE;
            }
        }
        return this.uid;
    }

    public boolean isAnswered() {
        if (this.isPersistent()) {
            try {
                if (this.node.hasProperty(ANSWERED_PROPERTY)) {
                    return this.node.getProperty(ANSWERED_PROPERTY).getBoolean();
                }
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:answered", (Throwable)e);
            }
            return false;
        }
        return this.answered;
    }

    public boolean isDeleted() {
        if (this.isPersistent()) {
            try {
                if (this.node.hasProperty(DELETED_PROPERTY)) {
                    return this.node.getProperty(DELETED_PROPERTY).getBoolean();
                }
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:deleted", (Throwable)e);
            }
            return false;
        }
        return this.deleted;
    }

    public boolean isDraft() {
        if (this.isPersistent()) {
            try {
                if (this.node.hasProperty(DRAFT_PROPERTY)) {
                    return this.node.getProperty(DRAFT_PROPERTY).getBoolean();
                }
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:draft", (Throwable)e);
            }
            return false;
        }
        return this.draft;
    }

    public boolean isFlagged() {
        if (this.isPersistent()) {
            try {
                if (this.node.hasProperty(FLAGGED_PROPERTY)) {
                    return this.node.getProperty(FLAGGED_PROPERTY).getBoolean();
                }
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:flagged", (Throwable)e);
            }
            return false;
        }
        return this.flagged;
    }

    public boolean isRecent() {
        if (this.isPersistent()) {
            try {
                if (this.node.hasProperty(RECENT_PROPERTY)) {
                    return this.node.getProperty(RECENT_PROPERTY).getBoolean();
                }
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:recent", (Throwable)e);
            }
            return false;
        }
        return this.recent;
    }

    public boolean isSeen() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(SEEN_PROPERTY).getBoolean();
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:seen", (Throwable)e);
                return false;
            }
        }
        return this.seen;
    }

    public void setFlags(Flags flags) {
        if (this.isPersistent()) {
            try {
                this.node.setProperty(ANSWERED_PROPERTY, flags.contains(Flags.Flag.ANSWERED));
                this.node.setProperty(DELETED_PROPERTY, flags.contains(Flags.Flag.DELETED));
                this.node.setProperty(DRAFT_PROPERTY, flags.contains(Flags.Flag.DRAFT));
                this.node.setProperty(FLAGGED_PROPERTY, flags.contains(Flags.Flag.FLAGGED));
                this.node.setProperty(RECENT_PROPERTY, flags.contains(Flags.Flag.RECENT));
                this.node.setProperty(SEEN_PROPERTY, flags.contains(Flags.Flag.SEEN));
                this.node.setProperty(USERFLAGS_PROPERTY, flags.getUserFlags());
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to set flags", (Throwable)e);
            }
        } else {
            this.answered = flags.contains(Flags.Flag.ANSWERED);
            this.deleted = flags.contains(Flags.Flag.DELETED);
            this.draft = flags.contains(Flags.Flag.DRAFT);
            this.flagged = flags.contains(Flags.Flag.FLAGGED);
            this.recent = flags.contains(Flags.Flag.RECENT);
            this.seen = flags.contains(Flags.Flag.SEEN);
            this.userFlags = flags.getUserFlags();
        }
    }

    public Flags createFlags() {
        return FlagsFactory.createFlags((MailboxMessage)this, (String[])this.userFlags);
    }

    public void unsetRecent() {
        if (this.isPersistent()) {
            try {
                this.node.setProperty(RECENT_PROPERTY, false);
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:recent", (Throwable)e);
            }
        } else {
            this.recent = false;
        }
    }

    public String getId() {
        if (this.isPersistent()) {
            try {
                return this.node.getIdentifier();
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jcr:uuid", (Throwable)e);
            }
        }
        return null;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.getUUID().hashCode();
        result = 31 * result + this.getMailboxId().hashCode();
        return result;
    }

    public String toString() {
        return "message(uuid = " + this.getUUID() + "mailboxUUID = " + this.getMailboxId() + TOSTRING_SEPARATOR + "uuid = " + this.getId() + TOSTRING_SEPARATOR + "internalDate = " + this.getInternalDate() + TOSTRING_SEPARATOR + "size = " + this.getFullContentOctets() + TOSTRING_SEPARATOR + "answered = " + this.isAnswered() + TOSTRING_SEPARATOR + "deleted = " + this.isDeleted() + TOSTRING_SEPARATOR + "draft = " + this.isDraft() + TOSTRING_SEPARATOR + "flagged = " + this.isFlagged() + TOSTRING_SEPARATOR + "recent = " + this.isRecent() + TOSTRING_SEPARATOR + "seen = " + this.isSeen() + TOSTRING_SEPARATOR + " )";
    }

    public InputStream getFullContent() throws IOException {
        if (this.isPersistent()) {
            try {
                return this.node.getNode("jcr:content").getProperty("jcr:data").getBinary().getStream();
            }
            catch (RepositoryException e) {
                throw new IOException("Unable to retrieve property jcr:content", e);
            }
        }
        return this.content.newStream(0L, -1L);
    }

    public InputStream getBodyContent() throws IOException {
        InputStream body = this.getFullContent();
        IOUtils.skipFully((InputStream)body, (long)this.getBodyStartOctet());
        return body;
    }

    public long getModSeq() {
        if (this.isPersistent()) {
            try {
                return this.node.getProperty(MODSEQ_PROPERTY).getLong();
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to access property jamesMailbox:modSeq", (Throwable)e);
                return 0L;
            }
        }
        return this.modSeq;
    }

    public void setModSeq(long modSeq) {
        if (this.isPersistent()) {
            try {
                this.node.setProperty(MODSEQ_PROPERTY, modSeq);
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to set mod-sequence", (Throwable)e);
            }
        } else {
            this.modSeq = modSeq;
        }
    }

    public void setUid(MessageUid uid) {
        if (this.isPersistent()) {
            try {
                this.node.setProperty(UID_PROPERTY, uid.asLong());
            }
            catch (RepositoryException e) {
                LOGGER.error("Unable to set uid", (Throwable)e);
            }
        } else {
            this.uid = uid;
        }
    }

    public InputStream getHeaderContent() throws IOException {
        long limit = this.getBodyStartOctet();
        if (limit < 0L) {
            limit = 0L;
        }
        return new BoundedInputStream(this.getFullContent(), limit);
    }

    public long getHeaderOctets() {
        return this.getBodyStartOctet();
    }

    public int compareTo(MailboxMessage other) {
        return MESSAGE_UID_COMPARATOR.compare(this, other);
    }

    public List<MessageAttachment> getAttachments() {
        try {
            return new MessageParser().retrieveAttachments(this.getFullContent());
        }
        catch (IOException | MimeException e) {
            throw new RuntimeException(e);
        }
    }
}

