/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jcr;

import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import org.apache.james.mailbox.jcr.MailboxSessionJCRRepository;
import org.apache.james.mailbox.store.Authenticator;

public class JCRRepositoryAuthenticator
implements Authenticator {
    private final MailboxSessionJCRRepository repository;

    public JCRRepositoryAuthenticator(MailboxSessionJCRRepository repository) {
        this.repository = repository;
    }

    public boolean isAuthentic(String userid, CharSequence passwd) {
        Repository repos = this.repository.getRepository();
        try {
            Session session = repos.login((Credentials)new SimpleCredentials(userid, passwd.toString().toCharArray()), this.repository.getWorkspace());
            session.logout();
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

