/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.quota;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.james.backends.jpa.TransactionRunner;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.quota.model.JpaCurrentQuota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.store.quota.StoreCurrentQuotaManager;

public class JpaCurrentQuotaManager
implements StoreCurrentQuotaManager {
    public static final long NO_MESSAGES = 0L;
    public static final long NO_STORED_BYTES = 0L;
    private final EntityManagerFactory entityManagerFactory;
    private final TransactionRunner transactionRunner;

    @Inject
    public JpaCurrentQuotaManager(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
        this.transactionRunner = new TransactionRunner(entityManagerFactory);
    }

    public MailboxListener.ListenerType getAssociatedListenerType() {
        return MailboxListener.ListenerType.ONCE;
    }

    public QuotaCount getCurrentMessageCount(QuotaRoot quotaRoot) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return Optional.ofNullable(this.retrieveUserQuota(entityManager, quotaRoot)).map(JpaCurrentQuota::getMessageCount).orElse(QuotaCount.count((long)0L));
    }

    public QuotaSize getCurrentStorage(QuotaRoot quotaRoot) {
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        return Optional.ofNullable(this.retrieveUserQuota(entityManager, quotaRoot)).map(JpaCurrentQuota::getSize).orElse(QuotaSize.size((long)0L));
    }

    public void increase(QuotaRoot quotaRoot, long count, long size) {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0, (Object)"Counts should be positive");
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"Size should be positive");
        this.transactionRunner.run(entityManager -> {
            JpaCurrentQuota jpaCurrentQuota = Optional.ofNullable(this.retrieveUserQuota((EntityManager)entityManager, quotaRoot)).orElse(new JpaCurrentQuota(quotaRoot.getValue(), 0L, 0L));
            entityManager.merge((Object)new JpaCurrentQuota(quotaRoot.getValue(), jpaCurrentQuota.getMessageCount().asLong() + count, jpaCurrentQuota.getSize().asLong() + size));
        });
    }

    public void decrease(QuotaRoot quotaRoot, long count, long size) throws MailboxException {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0, (Object)"Counts should be positive");
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"Counts should be positive");
        this.transactionRunner.run(entityManager -> {
            JpaCurrentQuota jpaCurrentQuota = Optional.ofNullable(this.retrieveUserQuota((EntityManager)entityManager, quotaRoot)).orElse(new JpaCurrentQuota(quotaRoot.getValue(), 0L, 0L));
            entityManager.merge((Object)new JpaCurrentQuota(quotaRoot.getValue(), jpaCurrentQuota.getMessageCount().asLong() - count, jpaCurrentQuota.getSize().asLong() - size));
        });
    }

    private JpaCurrentQuota retrieveUserQuota(EntityManager entityManager, QuotaRoot quotaRoot) {
        return (JpaCurrentQuota)entityManager.find(JpaCurrentQuota.class, (Object)quotaRoot.getValue());
    }
}

