/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa;

import java.util.EnumSet;
import org.apache.james.mailbox.MailboxAnnotationManager;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAMailboxSessionMapperFactory;
import org.apache.james.mailbox.jpa.mail.JPAMailboxMapper;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.store.Authenticator;
import org.apache.james.mailbox.store.Authorizator;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.StoreMailboxAnnotationManager;
import org.apache.james.mailbox.store.StoreMailboxManager;
import org.apache.james.mailbox.store.StoreRightManager;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.impl.MessageParser;
import org.apache.james.mailbox.store.transaction.Mapper;

public abstract class JPAMailboxManager
extends StoreMailboxManager {
    public static final EnumSet<MailboxManager.MailboxCapabilities> MAILBOX_CAPABILITIES = EnumSet.of(MailboxManager.MailboxCapabilities.UserFlag, MailboxManager.MailboxCapabilities.Namespace, MailboxManager.MailboxCapabilities.Move, MailboxManager.MailboxCapabilities.Annotation);

    public JPAMailboxManager(JPAMailboxSessionMapperFactory mailboxSessionMapperFactory, Authenticator authenticator, Authorizator authorizator, MailboxPathLocker locker, MessageParser messageParser, MessageId.Factory messageIdFactory, DelegatingMailboxListener delegatingMailboxListener, MailboxEventDispatcher mailboxEventDispatcher, StoreMailboxAnnotationManager annotationManager, StoreRightManager storeRightManager) {
        super((MailboxSessionMapperFactory)mailboxSessionMapperFactory, authenticator, authorizator, locker, messageParser, messageIdFactory, (MailboxAnnotationManager)annotationManager, mailboxEventDispatcher, delegatingMailboxListener, storeRightManager);
    }

    protected Mailbox doCreateMailbox(MailboxPath path, MailboxSession session) throws MailboxException {
        return new JPAMailbox(path, this.randomUidValidity());
    }

    public EnumSet<MailboxManager.MailboxCapabilities> getSupportedMailboxCapabilities() {
        return MAILBOX_CAPABILITIES;
    }

    public void deleteEverything(MailboxSession mailboxSession) throws MailboxException {
        JPAMailboxMapper mapper = (JPAMailboxMapper)this.getMapperFactory().getMailboxMapper(mailboxSession);
        mapper.execute(Mapper.toTransaction(mapper::deleteAllMemberships));
        mapper.execute(Mapper.toTransaction(mapper::deleteAllMailboxes));
    }
}

