/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn.fields;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.james.mdn.fields.Field;

public class ReportingUserAgent
implements Field {
    private static final String FIELD_NAME = "Reporting-UA";
    public static final Predicate<String> IS_EMPTY = String::isEmpty;
    private final String userAgentName;
    private final Optional<String> userAgentProduct;

    public static Builder builder() {
        return new Builder();
    }

    private ReportingUserAgent(String userAgentName, Optional<String> userAgentProduct) {
        this.userAgentName = userAgentName;
        this.userAgentProduct = userAgentProduct.map(String::trim).filter(IS_EMPTY.negate());
    }

    public String getUserAgentName() {
        return this.userAgentName;
    }

    public Optional<String> getUserAgentProduct() {
        return this.userAgentProduct;
    }

    @Override
    public String formattedValue() {
        return "Reporting-UA: " + this.userAgentName + "; " + this.userAgentProduct.orElse("");
    }

    public final boolean equals(Object o) {
        if (o instanceof ReportingUserAgent) {
            ReportingUserAgent that = (ReportingUserAgent)o;
            return Objects.equals(this.userAgentName, that.userAgentName) && Objects.equals(this.userAgentProduct, that.userAgentProduct);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.userAgentName, this.userAgentProduct);
    }

    public String toString() {
        return this.formattedValue();
    }

    public static class Builder {
        private String userAgentName;
        private Optional<String> userAgentProduct = Optional.empty();

        private Builder() {
        }

        public Builder userAgentName(String userAgentName) {
            this.userAgentName = userAgentName;
            return this;
        }

        public Builder userAgentProduct(String userAgentProduct) {
            this.userAgentProduct = Optional.of(userAgentProduct);
            return this;
        }

        public ReportingUserAgent build() {
            Preconditions.checkNotNull((Object)this.userAgentName);
            Preconditions.checkNotNull(this.userAgentProduct);
            Preconditions.checkState((!this.userAgentName.contains("\n") ? 1 : 0) != 0, (Object)"Name should not contain line break");
            String trimmedName = this.userAgentName.trim();
            Preconditions.checkState((!trimmedName.isEmpty() ? 1 : 0) != 0, (Object)"Name should not be empty");
            return new ReportingUserAgent(trimmedName, this.userAgentProduct);
        }
    }
}

