/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mdn;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.james.mdn.BaseParser;
import org.apache.james.mdn.MDNReport;
import org.apache.james.mdn.action.mode.DispositionActionMode;
import org.apache.james.mdn.fields.AddressType;
import org.apache.james.mdn.fields.Disposition;
import org.apache.james.mdn.fields.Error;
import org.apache.james.mdn.fields.ExtensionField;
import org.apache.james.mdn.fields.FinalRecipient;
import org.apache.james.mdn.fields.Gateway;
import org.apache.james.mdn.fields.OriginalMessageId;
import org.apache.james.mdn.fields.OriginalRecipient;
import org.apache.james.mdn.fields.ReportingUserAgent;
import org.apache.james.mdn.fields.Text;
import org.apache.james.mdn.modifier.DispositionModifier;
import org.apache.james.mdn.sending.mode.DispositionSendingMode;
import org.apache.james.mdn.type.DispositionType;
import org.parboiled.Parboiled;
import org.parboiled.Rule;
import org.parboiled.parserunners.ReportingParseRunner;
import org.parboiled.support.ParsingResult;

public class MDNReportParser {
    public Optional<MDNReport> parse(InputStream is, String charset) throws IOException {
        return this.parse(IOUtils.toString((InputStream)is, (String)charset));
    }

    public Optional<MDNReport> parse(String mdnReport) {
        Parser parser = (Parser)Parboiled.createParser(Parser.class, (Object[])new Object[0]);
        ParsingResult result = new ReportingParseRunner(parser.dispositionNotificationContent()).run(mdnReport);
        if (result.matched) {
            return Optional.of((MDNReport)result.resultValue);
        }
        return Optional.empty();
    }

    @VisibleForTesting
    static class Parser
    extends BaseParser<Object> {
        Parser() {
        }

        Rule cfws() {
            return this.FirstOf(this.Sequence(this.OneOrMore(this.Sequence(this.Optional(this.fws()), this.comment(), new Object[0])), this.Optional(this.fws()), new Object[0]), this.fws(), new Object[0]);
        }

        Rule fws() {
            return this.FirstOf(this.Sequence(this.Optional(this.Sequence(this.ZeroOrMore(this.wsp()), this.crlf(), new Object[0])), this.OneOrMore(this.wsp()), new Object[0]), this.obsFWS(), new Object[0]);
        }

        Rule wsp() {
            return this.FirstOf(this.sp(), this.htab(), new Object[0]);
        }

        Rule sp() {
            return this.Ch(' ');
        }

        Rule htab() {
            return this.Ch('\t');
        }

        Rule crlf() {
            return this.Sequence(this.cr(), this.lf(), new Object[0]);
        }

        Rule cr() {
            return this.Ch('\r');
        }

        Rule lf() {
            return this.Ch('\n');
        }

        Rule obsFWS() {
            return this.Sequence(this.OneOrMore(this.wsp()), this.ZeroOrMore(this.Sequence(this.crlf(), this.OneOrMore(this.wsp()), new Object[0])), new Object[0]);
        }

        Rule comment() {
            return this.Sequence("(", this.ZeroOrMore(this.Sequence(this.Optional(this.fws()), this.ccontent(), new Object[0])), new Object[]{this.Optional(this.fws()), ")"});
        }

        Rule ccontent() {
            return this.FirstOf(this.ctext(), this.quotedPair(), new Object[]{this.comment()});
        }

        Rule ctext() {
            return this.FirstOf(this.CharRange('!', '\''), this.CharRange('*', '['), new Object[]{this.CharRange(']', '~'), this.obsCtext()});
        }

        Rule obsCtext() {
            return this.obsNoWsCtl();
        }

        Rule obsNoWsCtl() {
            return this.FirstOf(this.CharRange('\u0001', '\b'), this.Ch('\u000b'), new Object[]{this.Ch('\f'), this.CharRange('\u000e', '\u001f'), this.Ch('\u007f')});
        }

        Rule quotedPair() {
            return this.FirstOf(this.Sequence("\\", this.FirstOf(this.vchar(), this.wsp(), new Object[0]), new Object[0]), this.obsQp(), new Object[0]);
        }

        Rule vchar() {
            return this.CharRange('!', '~');
        }

        Rule obsQp() {
            return this.Sequence("\\", this.FirstOf(this.Ch('\u00d0'), this.obsCtext(), new Object[]{this.lf(), this.cr()}), new Object[0]);
        }

        Rule word() {
            return this.FirstOf(this.atom(), this.quotedString(), new Object[0]);
        }

        Rule atom() {
            return this.Sequence(this.Optional(this.cfws()), this.OneOrMore(this.atext()), new Object[]{this.Optional(this.cfws())});
        }

        Rule atext() {
            return this.FirstOf(this.alpha(), this.digit(), new Object[]{"!", "#", "$", "%", "&", "'", "*", "+", "-", "/", "=", "?", "^", "_", "`", "{", "|", "}", "~"});
        }

        Rule alpha() {
            return this.FirstOf(this.CharRange('A', 'Z'), this.CharRange('a', 'z'), new Object[0]);
        }

        Rule digit() {
            return this.CharRange('0', '9');
        }

        Rule quotedString() {
            return this.Sequence(this.Optional(this.cfws()), this.Sequence(this.dquote(), this.ZeroOrMore(this.Sequence(this.Optional(this.fws()), this.qcontent(), new Object[0]), this.Optional(this.fws()), new Object[]{this.dquote()}), new Object[0]), new Object[]{this.Optional(this.cfws())});
        }

        Rule dquote() {
            return this.Ch('\"');
        }

        Rule qcontent() {
            return this.FirstOf(this.qcontent(), this.quotedPair(), new Object[0]);
        }

        Rule domain() {
            return this.FirstOf(this.dotAtom(), this.domainLiteral(), new Object[]{this.obsDomain()});
        }

        Rule dotAtom() {
            return this.Sequence(this.Optional(this.cfws()), this.dotAtomText(), new Object[]{this.Optional(this.cfws())});
        }

        Rule dotAtomText() {
            return this.Sequence(this.OneOrMore(this.atext()), this.ZeroOrMore(this.Sequence(".", this.OneOrMore(this.atext()), new Object[0])), new Object[0]);
        }

        Rule domainLiteral() {
            return this.Sequence(this.Optional(this.cfws()), "[", new Object[]{this.ZeroOrMore(this.Sequence(this.Optional(this.fws()), this.dtext(), new Object[0]), this.Optional(this.fws()), new Object[]{"]", this.Optional(this.cfws())})});
        }

        Rule dtext() {
            return this.FirstOf(this.CharRange('!', 'Z'), this.CharRange('^', '~'), new Object[]{this.obsDtext()});
        }

        Rule obsDtext() {
            return this.FirstOf(this.obsNoWsCtl(), this.quotedPair(), new Object[0]);
        }

        Rule obsDomain() {
            return this.Sequence(this.atom(), this.ZeroOrMore(this.Sequence(".", this.atom(), new Object[0])), new Object[0]);
        }

        Rule localPart() {
            return this.FirstOf(this.dotAtom(), this.quotedString(), new Object[]{this.obsLocalPart()});
        }

        Rule obsLocalPart() {
            return this.Sequence(this.word(), this.ZeroOrMore(this.Sequence(".", this.word(), new Object[0])), new Object[0]);
        }

        Rule dispositionNotificationContent() {
            return this.Sequence(this.push(MDNReport.builder()), this.Optional(this.Sequence(this.reportingUaField(), Parser.ACTION((boolean)this.setReportingUaField()), new Object[]{this.crlf()})), new Object[]{this.Optional(this.Sequence(this.mdnGatewayField(), Parser.ACTION((boolean)this.setMdnGatewayField()), new Object[]{this.crlf()})), this.Optional(this.Sequence(this.originalRecipientField(), Parser.ACTION((boolean)this.setOriginalRecipientField()), new Object[]{this.crlf()})), this.Sequence(this.finalRecipientField(), Parser.ACTION((boolean)this.setFinalRecipientField()), new Object[]{this.crlf()}), this.Optional(this.Sequence(this.originalMessageIdField(), Parser.ACTION((boolean)this.setOriginalMessageIdField()), new Object[]{this.crlf()})), this.Sequence(this.dispositionField(), Parser.ACTION((boolean)this.setDispositionField()), new Object[]{this.crlf()}), this.ZeroOrMore(this.Sequence(this.errorField(), Parser.ACTION((boolean)this.addErrorField()), new Object[]{this.crlf()})), this.ZeroOrMore(this.Sequence(this.extentionField(), Parser.ACTION((boolean)this.addExtensionField()), new Object[]{this.crlf()})), Parser.ACTION((boolean)this.buildMDNReport())});
        }

        boolean setReportingUaField() {
            ((MDNReport.Builder)this.peekParent()).reportingUserAgentField((ReportingUserAgent)this.popT());
            return true;
        }

        boolean setMdnGatewayField() {
            ((MDNReport.Builder)this.peekParent()).gatewayField((Gateway)this.popT());
            return true;
        }

        boolean setOriginalRecipientField() {
            ((MDNReport.Builder)this.peekParent()).originalRecipientField((OriginalRecipient)this.popT());
            return true;
        }

        boolean setFinalRecipientField() {
            ((MDNReport.Builder)this.peekParent()).finalRecipientField((FinalRecipient)this.popT());
            return true;
        }

        boolean setOriginalMessageIdField() {
            ((MDNReport.Builder)this.peekParent()).originalMessageIdField((OriginalMessageId)this.popT());
            return true;
        }

        boolean setDispositionField() {
            ((MDNReport.Builder)this.peekParent()).dispositionField((Disposition)this.popT());
            return true;
        }

        boolean addErrorField() {
            ((MDNReport.Builder)this.peekParent()).addErrorField((Error)this.popT());
            return true;
        }

        boolean addExtensionField() {
            ((MDNReport.Builder)this.peekParent()).withExtensionField((ExtensionField)this.popT());
            return true;
        }

        boolean buildMDNReport() {
            this.push(((MDNReport.Builder)this.popT()).build());
            return true;
        }

        Rule reportingUaField() {
            return this.Sequence(this.push(ReportingUserAgent.builder()), "Reporting-UA", new Object[]{":", this.ows(), this.uaName(), Parser.ACTION((boolean)this.setUserAgentName()), this.ows(), this.Optional(this.Sequence(";", this.ows(), new Object[]{this.uaProduct(), Parser.ACTION((boolean)this.setUserAgentProduct()), this.ows()})), Parser.ACTION((boolean)this.buildReportingUserAgent())});
        }

        boolean buildReportingUserAgent() {
            this.push(((ReportingUserAgent.Builder)this.popT()).build());
            return true;
        }

        boolean setUserAgentName() {
            ((ReportingUserAgent.Builder)this.peekT()).userAgentName(this.match());
            return true;
        }

        boolean setUserAgentProduct() {
            ((ReportingUserAgent.Builder)this.peekT()).userAgentProduct(this.match());
            return true;
        }

        Rule uaName() {
            return this.ZeroOrMore(this.textNoSemi());
        }

        Rule textNoSemi() {
            return this.FirstOf(this.CharRange('\u0001', '\t'), Character.toChars(11), new Object[]{Character.toChars(12), this.CharRange('\u000e', ':'), this.CharRange('<', '\u007f')});
        }

        Rule uaProduct() {
            return this.ZeroOrMore(this.Sequence(this.Optional(this.fws()), this.text(), new Object[0]));
        }

        Rule text() {
            return this.FirstOf(this.CharRange('\u0001', '\t'), Character.toChars(11), new Object[]{Character.toChars(12), this.CharRange('\u000e', '\u007f')});
        }

        Rule ows() {
            return this.Optional(this.cfws());
        }

        Rule mdnGatewayField() {
            return this.Sequence(this.push(Gateway.builder()), "MDN-Gateway", new Object[]{":", this.ows(), this.mtaNameType(), Parser.ACTION((boolean)this.setMtaNameType()), this.ows(), ";", this.ows(), this.mtaName(), Parser.ACTION((boolean)this.setMtaName()), Parser.ACTION((boolean)this.buildGateway())});
        }

        boolean setMtaNameType() {
            ((Gateway.Builder)this.peekT()).nameType(new AddressType(this.match()));
            return true;
        }

        boolean setMtaName() {
            ((Gateway.Builder)this.peekT()).name(Text.fromRawText(this.match()));
            return true;
        }

        boolean buildGateway() {
            this.push(((Gateway.Builder)this.popT()).build());
            return true;
        }

        Rule mtaNameType() {
            return this.atom();
        }

        Rule mtaName() {
            return this.ZeroOrMore(this.text());
        }

        Rule originalRecipientField() {
            return this.Sequence(this.push(OriginalRecipient.builder()), "Original-Recipient", new Object[]{":", this.ows(), this.addressType(), Parser.ACTION((boolean)this.setOriginalAddressType()), this.ows(), ";", this.ows(), this.genericAddress(), Parser.ACTION((boolean)this.setOriginalGenericAddress()), this.ows(), Parser.ACTION((boolean)this.buildOriginalRecipient())});
        }

        boolean setOriginalAddressType() {
            ((OriginalRecipient.Builder)this.peekT()).addressType(new AddressType(this.match()));
            return true;
        }

        boolean setOriginalGenericAddress() {
            ((OriginalRecipient.Builder)this.peekT()).originalRecipient(Text.fromRawText(this.match()));
            return true;
        }

        boolean buildOriginalRecipient() {
            this.push(((OriginalRecipient.Builder)this.popT()).build());
            return true;
        }

        Rule addressType() {
            return this.atom();
        }

        Rule genericAddress() {
            return this.ZeroOrMore(this.text());
        }

        Rule finalRecipientField() {
            return this.Sequence(this.push(FinalRecipient.builder()), "Final-Recipient", new Object[]{":", this.ows(), this.addressType(), Parser.ACTION((boolean)this.setFinalAddressType()), this.ows(), ";", this.ows(), this.genericAddress(), Parser.ACTION((boolean)this.setFinalGenericAddress()), this.ows(), Parser.ACTION((boolean)this.buildFinalRecipient())});
        }

        boolean setFinalAddressType() {
            ((FinalRecipient.Builder)this.peekT()).addressType(new AddressType(this.match()));
            return true;
        }

        boolean setFinalGenericAddress() {
            ((FinalRecipient.Builder)this.peekT()).finalRecipient(Text.fromRawText(this.match()));
            return true;
        }

        boolean buildFinalRecipient() {
            this.push(((FinalRecipient.Builder)this.popT()).build());
            return true;
        }

        Rule originalMessageIdField() {
            return this.Sequence("Original-Message-ID", ":", new Object[]{this.msgId(), this.push(new OriginalMessageId(this.match()))});
        }

        Rule msgId() {
            return this.Sequence(this.Optional(this.cfws()), "<", new Object[]{this.idLeft(), "@", this.idRight(), ">", this.Optional(this.cfws())});
        }

        Rule idLeft() {
            return this.FirstOf(this.dotAtomText(), this.obsIdLeft(), new Object[0]);
        }

        Rule obsIdLeft() {
            return this.localPart();
        }

        Rule idRight() {
            return this.domain();
        }

        Rule dispositionField() {
            return this.Sequence(this.push(Disposition.builder()), "Disposition", new Object[]{":", this.ows(), this.dispositionMode(), this.ows(), ";", this.ows(), this.dispositionType(), this.Optional(this.Sequence(this.ows(), "/", new Object[]{this.ows(), this.dispositionModifier(), Parser.ACTION((boolean)this.addDispositionModifier()), this.ZeroOrMore(this.Sequence(this.ows(), ",", new Object[]{this.dispositionModifier(), Parser.ACTION((boolean)this.addDispositionModifier())}))})), this.ows(), Parser.ACTION((boolean)this.buildDispositionField())});
        }

        boolean addDispositionModifier() {
            ((Disposition.Builder)this.peekT()).addModifier(new DispositionModifier(this.match()));
            return true;
        }

        boolean buildDispositionField() {
            this.push(((Disposition.Builder)this.popT()).build());
            return true;
        }

        Rule dispositionMode() {
            return this.Sequence(this.actionMode(), this.ows(), new Object[]{"/", this.ows(), this.sendingMode()});
        }

        Rule actionMode() {
            return this.FirstOf(this.Sequence("manual-action", Parser.ACTION((boolean)this.setActionMode(DispositionActionMode.Manual)), new Object[0]), this.Sequence("automatic-action", Parser.ACTION((boolean)this.setActionMode(DispositionActionMode.Automatic)), new Object[0]), new Object[0]);
        }

        boolean setActionMode(DispositionActionMode actionMode) {
            ((Disposition.Builder)this.peekT()).actionMode(actionMode);
            return true;
        }

        Rule sendingMode() {
            return this.FirstOf(this.Sequence("MDN-sent-manually", Parser.ACTION((boolean)this.setSendingMode(DispositionSendingMode.Manual)), new Object[0]), this.Sequence("MDN-sent-automatically", Parser.ACTION((boolean)this.setSendingMode(DispositionSendingMode.Automatic)), new Object[0]), new Object[0]);
        }

        boolean setSendingMode(DispositionSendingMode sendingMode) {
            ((Disposition.Builder)this.peekT()).sendingMode(sendingMode);
            return true;
        }

        Rule dispositionType() {
            return this.FirstOf(this.Sequence("displayed", Parser.ACTION((boolean)this.setDispositionType(DispositionType.Displayed)), new Object[0]), this.Sequence("deleted", Parser.ACTION((boolean)this.setDispositionType(DispositionType.Deleted)), new Object[0]), new Object[]{this.Sequence("dispatched", Parser.ACTION((boolean)this.setDispositionType(DispositionType.Dispatched)), new Object[0]), this.Sequence("processed", Parser.ACTION((boolean)this.setDispositionType(DispositionType.Processed)), new Object[0])});
        }

        boolean setDispositionType(DispositionType type) {
            ((Disposition.Builder)this.peekT()).type(type);
            return true;
        }

        Rule dispositionModifier() {
            return this.FirstOf("error", this.dispositionModifierExtension(), new Object[0]);
        }

        Rule dispositionModifierExtension() {
            return this.atom();
        }

        Rule errorField() {
            return this.Sequence("Error", ":", new Object[]{this.ZeroOrMore(this.Sequence(this.Optional(this.fws()), this.text(), new Object[0])), this.push(new Error(Text.fromRawText(this.match())))});
        }

        Rule extentionField() {
            return this.Sequence(this.push(ExtensionField.builder()), this.extensionFieldName(), new Object[]{Parser.ACTION((boolean)this.setExtensionFieldName()), ":", this.ZeroOrMore(this.Sequence(this.Optional(this.fws()), this.text(), new Object[0])), Parser.ACTION((boolean)this.setExtensionText()), Parser.ACTION((boolean)this.buildExtension())});
        }

        boolean setExtensionFieldName() {
            ((ExtensionField.Builder)this.peekT()).fieldName(this.match());
            return true;
        }

        boolean setExtensionText() {
            ((ExtensionField.Builder)this.peekT()).rawValue(this.match());
            return true;
        }

        boolean buildExtension() {
            this.push(((ExtensionField.Builder)this.popT()).build());
            return true;
        }

        Rule extensionFieldName() {
            return this.fieldName();
        }

        Rule fieldName() {
            return this.OneOrMore(this.ftext());
        }

        Rule ftext() {
            return this.FirstOf(this.CharRange('!', '9'), this.CharRange(';', '~'), new Object[0]);
        }
    }
}

