/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.api;

import java.util.Map;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;

public interface RecipientRewriteTable {
    public static final String WILDCARD = "*";

    public void addMapping(MappingSource var1, Mapping var2) throws RecipientRewriteTableException;

    public void removeMapping(MappingSource var1, Mapping var2) throws RecipientRewriteTableException;

    public void addRegexMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeRegexMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addAddressMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeAddressMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addErrorMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeErrorMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addAliasDomainMapping(MappingSource var1, Domain var2) throws RecipientRewriteTableException;

    public void removeAliasDomainMapping(MappingSource var1, Domain var2) throws RecipientRewriteTableException;

    public void addForwardMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeForwardMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void addGroupMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public void removeGroupMapping(MappingSource var1, String var2) throws RecipientRewriteTableException;

    public Mappings getMappings(String var1, Domain var2) throws ErrorMappingException, RecipientRewriteTableException;

    public Mappings getUserDomainMappings(MappingSource var1) throws RecipientRewriteTableException;

    public Map<MappingSource, Mappings> getAllMappings() throws RecipientRewriteTableException;

    public static class TooManyMappingException
    extends ErrorMappingException {
        public TooManyMappingException(String string) {
            super(string);
        }
    }

    public static class ErrorMappingException
    extends Exception {
        private static final long serialVersionUID = 2348752938798L;

        public ErrorMappingException(String string) {
            super(string);
        }
    }

    public static interface Domains {
        public static final Domain WILDCARD = new Domain("*"){

            public String name() {
                throw new IllegalStateException();
            }

            public String toString() {
                return "Domain : * (Wildcard)";
            }
        };
    }
}

