/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.pop3.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Request;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;
import org.apache.james.protocols.pop3.POP3StreamResponse;
import org.apache.james.protocols.pop3.core.CRLFTerminatedInputStream;
import org.apache.james.protocols.pop3.core.CapaCapability;
import org.apache.james.protocols.pop3.core.ExtraDotInputStream;
import org.apache.james.protocols.pop3.core.MessageMetaDataUtils;
import org.apache.james.protocols.pop3.core.RetrCmdHandler;
import org.apache.james.protocols.pop3.mailbox.MessageMetaData;

public class TopCmdHandler
extends RetrCmdHandler
implements CapaCapability {
    private static final Collection<String> COMMANDS = ImmutableList.of((Object)"TOP");
    private static final Set<String> CAPS = ImmutableSet.of((Object)"TOP");
    private static final Response SYNTAX_ERROR = new POP3Response("-ERR", "Usage: TOP [mail number] [Line number]").immutable();
    private static final Response ERROR_MESSAGE_RETR = new POP3Response("-ERR", "Error while retrieving message.").immutable();

    @Override
    public Response onCommand(POP3Session session, Request request) {
        String parameters = request.getArgument();
        if (parameters == null) {
            return SYNTAX_ERROR;
        }
        String argument = "";
        String argument1 = "";
        int pos = parameters.indexOf(" ");
        if (pos > 0) {
            argument = parameters.substring(0, pos);
            argument1 = parameters.substring(pos + 1);
        }
        if (session.getHandlerState() == 2) {
            int num = 0;
            int lines = -1;
            try {
                num = Integer.parseInt(argument);
                lines = Integer.parseInt(argument1);
            }
            catch (NumberFormatException nfe) {
                return SYNTAX_ERROR;
            }
            try {
                String uid;
                MessageMetaData data = MessageMetaDataUtils.getMetaData(session, num);
                if (data == null) {
                    StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                    return new POP3Response("-ERR", responseBuffer.toString());
                }
                List deletedUidList = (List)session.getAttachment("DELETED_UID_LIST", ProtocolSession.State.Transaction);
                if (!deletedUidList.contains(uid = data.getUid())) {
                    CountingBodyInputStream message = new CountingBodyInputStream(new ExtraDotInputStream(new CRLFTerminatedInputStream(session.getUserMailbox().getMessage(uid))), lines);
                    return new POP3StreamResponse("+OK", "Message follows", message);
                }
                StringBuilder responseBuffer = new StringBuilder(64).append("Message (").append(num).append(") already deleted.");
                return new POP3Response("-ERR", responseBuffer.toString());
            }
            catch (IOException ioe) {
                return ERROR_MESSAGE_RETR;
            }
            catch (IndexOutOfBoundsException | NoSuchElementException iob) {
                StringBuilder exceptionBuffer = new StringBuilder(64).append("Message (").append(num).append(") does not exist.");
                return new POP3Response("-ERR", exceptionBuffer.toString());
            }
        }
        return POP3Response.ERR;
    }

    @Override
    public Set<String> getImplementedCapabilities(POP3Session session) {
        if (session.getHandlerState() == 2) {
            return CAPS;
        }
        return Collections.EMPTY_SET;
    }

    @Override
    public Collection<String> getImplCommands() {
        return COMMANDS;
    }

    private final class CountingBodyInputStream
    extends InputStream {
        private int count = 0;
        private int limit = -1;
        private int lastChar;
        private final InputStream in;
        private boolean isBody = false;
        private boolean isEmptyLine = false;

        public CountingBodyInputStream(InputStream in, int limit) {
            this.in = in;
            this.limit = limit;
        }

        @Override
        public int read() throws IOException {
            if (this.limit != -1) {
                if (this.count <= this.limit) {
                    int a = this.in.read();
                    if (!this.isBody && this.isEmptyLine && this.lastChar == 13 && a == 10) {
                        this.isBody = true;
                    }
                    if (this.lastChar == 13 && a == 10) {
                        this.isEmptyLine = true;
                        if (this.isBody) {
                            ++this.count;
                        }
                    } else if (this.lastChar == 10 && a != 13) {
                        this.isEmptyLine = false;
                    }
                    this.lastChar = a;
                    return a;
                }
                return -1;
            }
            return this.in.read();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public void mark(int readlimit) {
        }

        @Override
        public void reset() throws IOException {
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

