/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.lib;

import com.github.fge.lambdas.Throwing;
import com.github.steveash.guavate.Guavate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.Domain;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.DomainListConfiguration;
import org.apache.james.domainlist.lib.EnvDetector;
import org.apache.james.lifecycle.api.Configurable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDomainList
implements DomainList,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDomainList.class);
    public static final String CONFIGURE_AUTODETECT = "autodetect";
    public static final String CONFIGURE_AUTODETECT_IP = "autodetectIP";
    public static final String CONFIGURE_DEFAULT_DOMAIN = "defaultDomain";
    public static final String CONFIGURE_DOMAIN_NAMES = "domainnames.domainname";
    public static final String ENV_DOMAIN = "DOMAIN";
    private final DNSService dns;
    private final EnvDetector envDetector;
    private boolean autoDetect = true;
    private boolean autoDetectIP = true;
    private Domain defaultDomain;

    public AbstractDomainList(DNSService dns, EnvDetector envDetector) {
        this.dns = dns;
        this.envDetector = envDetector;
    }

    public AbstractDomainList(DNSService dns) {
        this(dns, new EnvDetector());
    }

    public void configure(HierarchicalConfiguration config) throws ConfigurationException {
        DomainListConfiguration domainListConfiguration = DomainListConfiguration.from(config);
        this.configure(domainListConfiguration);
    }

    public void configure(DomainListConfiguration domainListConfiguration) throws ConfigurationException {
        this.setAutoDetect(domainListConfiguration.isAutoDetect());
        this.setAutoDetectIP(domainListConfiguration.isAutoDetectIp());
        this.configureDefaultDomain(domainListConfiguration.getDefaultDomain());
        this.addEnvDomain();
        this.addConfiguredDomains(domainListConfiguration.getConfiguredDomains());
    }

    public void configure(DomainListConfiguration.Builder configurationBuilder) throws ConfigurationException {
        this.configure(configurationBuilder.build());
    }

    protected void addConfiguredDomains(List<Domain> domains) {
        domains.stream().filter(Throwing.predicate(domain -> !this.containsDomainInternal((Domain)domain)).sneakyThrow()).forEach(Throwing.consumer(arg_0 -> ((AbstractDomainList)this).addDomain(arg_0)).sneakyThrow());
    }

    private void addEnvDomain() {
        String envDomain = this.envDetector.getEnv(ENV_DOMAIN);
        if (!Strings.isNullOrEmpty((String)envDomain)) {
            try {
                LOGGER.info("Adding environment defined domain {}", (Object)envDomain);
                this.addDomain(Domain.of((String)envDomain));
            }
            catch (DomainListException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @VisibleForTesting
    void configureDefaultDomain(Domain defaultDomain) throws ConfigurationException {
        try {
            this.setDefaultDomain(defaultDomain);
            String hostName = InetAddress.getLocalHost().getHostName();
            if (this.mayChangeDefaultDomain()) {
                this.setDefaultDomain(Domain.of((String)hostName));
            }
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Unable to retrieve hostname.", (Throwable)e);
        }
        catch (DomainListException e) {
            LOGGER.error("An error occured while creating the default domain", (Throwable)e);
        }
    }

    private boolean mayChangeDefaultDomain() {
        return this.autoDetect && Domain.LOCALHOST.equals((Object)this.defaultDomain);
    }

    private void setDefaultDomain(Domain defaultDomain) throws DomainListException {
        if (defaultDomain != null && !this.containsDomain(defaultDomain)) {
            this.addDomain(defaultDomain);
        }
        this.defaultDomain = defaultDomain;
    }

    public Domain getDefaultDomain() throws DomainListException {
        if (this.defaultDomain != null) {
            return this.defaultDomain;
        }
        throw new DomainListException("Null default domain. Domain list might not be configured yet.");
    }

    public boolean containsDomain(Domain domain) throws DomainListException {
        boolean internalAnswer = this.containsDomainInternal(domain);
        return internalAnswer || this.getDomains().contains((Object)domain);
    }

    public ImmutableList<Domain> getDomains() throws DomainListException {
        List<Domain> domains = this.getDomainListInternal();
        ImmutableList<Domain> detectedDomains = this.detectDomains();
        Iterable domainsWithoutIp = Iterables.concat(domains, detectedDomains);
        ImmutableList<Domain> detectedIps = this.detectIps(domainsWithoutIp);
        ImmutableList allDomains = ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)domainsWithoutIp, detectedIps));
        if (LOGGER.isDebugEnabled()) {
            for (Domain domain : allDomains) {
                LOGGER.debug("Handling mail for: " + domain.name());
            }
        }
        return allDomains;
    }

    private ImmutableList<Domain> detectIps(Iterable<Domain> domains) {
        if (this.autoDetectIP) {
            return (ImmutableList)AbstractDomainList.getDomainsIpStream(domains, this.dns, LOGGER).collect(Guavate.toImmutableList());
        }
        return ImmutableList.of();
    }

    private ImmutableList<Domain> detectDomains() {
        if (this.autoDetect) {
            String hostName;
            try {
                hostName = this.dns.getHostName(this.dns.getLocalHost());
            }
            catch (UnknownHostException ue) {
                hostName = "localhost";
            }
            LOGGER.info("Local host is: {}", (Object)hostName);
            if (hostName != null && !hostName.equals("localhost")) {
                return ImmutableList.of((Object)Domain.of((String)hostName));
            }
        }
        return ImmutableList.of();
    }

    private static Stream<Domain> getDomainsIpStream(Iterable<Domain> domains, DNSService dns, Logger log) {
        return Guavate.stream(domains).flatMap(domain -> AbstractDomainList.getDomainIpStream(domain, dns, log)).distinct();
    }

    private static Stream<Domain> getDomainIpStream(Domain domain, DNSService dns, Logger log) {
        try {
            return dns.getAllByName(domain.name()).stream().map(InetAddress::getHostAddress).map(Domain::of).distinct();
        }
        catch (UnknownHostException e) {
            log.error("Cannot get IP address(es) for {}", (Object)domain);
            return Stream.of(new Domain[0]);
        }
    }

    public synchronized void setAutoDetect(boolean autoDetect) {
        LOGGER.info("Set autodetect to: {}", (Object)autoDetect);
        this.autoDetect = autoDetect;
    }

    public synchronized void setAutoDetectIP(boolean autoDetectIP) {
        LOGGER.info("Set autodetectIP to: {}", (Object)autoDetectIP);
        this.autoDetectIP = autoDetectIP;
    }

    protected abstract List<Domain> getDomainListInternal() throws DomainListException;

    protected abstract boolean containsDomainInternal(Domain var1) throws DomainListException;
}

