/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing.aggregates;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.core.Domain;
import org.apache.james.eventsourcing.AggregateId;

public class DLPAggregateId
implements AggregateId {
    private static final String SEPARATOR = "/";
    private static final String PREFIX = "DLPRule";
    private final Domain domain;

    public static final DLPAggregateId parse(String rawString) {
        Preconditions.checkArgument((boolean)rawString.startsWith("DLPRule/"));
        return new DLPAggregateId(Domain.of((String)rawString.substring(PREFIX.length() + SEPARATOR.length())));
    }

    public DLPAggregateId(Domain domain) {
        Preconditions.checkNotNull((Object)domain);
        this.domain = domain;
    }

    public String asAggregateKey() {
        return "DLPRule/" + this.domain.asString();
    }

    public final boolean equals(Object o) {
        if (o instanceof DLPAggregateId) {
            DLPAggregateId that = (DLPAggregateId)o;
            return Objects.equals(this.domain, that.domain);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.domain);
    }
}

