/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.james.task.Task;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManager;

public class TaskExecutionDetails {
    private final TaskId taskId;
    private final Task task;
    private final TaskManager.Status status;
    private final Optional<ZonedDateTime> submitDate;
    private final Optional<ZonedDateTime> startedDate;
    private final Optional<ZonedDateTime> completedDate;
    private final Optional<ZonedDateTime> canceledDate;
    private final Optional<ZonedDateTime> failedDate;

    public static TaskExecutionDetails from(Task task, TaskId id) {
        return new TaskExecutionDetails(id, task, TaskManager.Status.WAITING, Optional.of(ZonedDateTime.now()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public TaskExecutionDetails(TaskId taskId, Task task, TaskManager.Status status, Optional<ZonedDateTime> submitDate, Optional<ZonedDateTime> startedDate, Optional<ZonedDateTime> completedDate, Optional<ZonedDateTime> canceledDate, Optional<ZonedDateTime> failedDate) {
        this.taskId = taskId;
        this.task = task;
        this.status = status;
        this.submitDate = submitDate;
        this.startedDate = startedDate;
        this.completedDate = completedDate;
        this.canceledDate = canceledDate;
        this.failedDate = failedDate;
    }

    public TaskId getTaskId() {
        return this.taskId;
    }

    public String getType() {
        return this.task.type();
    }

    public TaskManager.Status getStatus() {
        return this.status;
    }

    public Optional<AdditionalInformation> getAdditionalInformation() {
        return this.task.details();
    }

    public Optional<ZonedDateTime> getSubmitDate() {
        return this.submitDate;
    }

    public Optional<ZonedDateTime> getStartedDate() {
        return this.startedDate;
    }

    public Optional<ZonedDateTime> getCompletedDate() {
        return this.completedDate;
    }

    public Optional<ZonedDateTime> getCanceledDate() {
        return this.canceledDate;
    }

    public Optional<ZonedDateTime> getFailedDate() {
        return this.failedDate;
    }

    public TaskExecutionDetails start() {
        Preconditions.checkState((this.status == TaskManager.Status.WAITING ? 1 : 0) != 0);
        return new TaskExecutionDetails(this.taskId, this.task, TaskManager.Status.IN_PROGRESS, this.submitDate, Optional.of(ZonedDateTime.now()), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public TaskExecutionDetails completed() {
        Preconditions.checkState((this.status == TaskManager.Status.IN_PROGRESS ? 1 : 0) != 0);
        return new TaskExecutionDetails(this.taskId, this.task, TaskManager.Status.COMPLETED, this.submitDate, this.startedDate, Optional.of(ZonedDateTime.now()), Optional.empty(), Optional.empty());
    }

    public TaskExecutionDetails failed() {
        Preconditions.checkState((this.status == TaskManager.Status.IN_PROGRESS ? 1 : 0) != 0);
        return new TaskExecutionDetails(this.taskId, this.task, TaskManager.Status.FAILED, this.submitDate, this.startedDate, Optional.empty(), Optional.empty(), Optional.of(ZonedDateTime.now()));
    }

    public TaskExecutionDetails cancel() {
        Preconditions.checkState((this.status == TaskManager.Status.IN_PROGRESS || this.status == TaskManager.Status.WAITING ? 1 : 0) != 0);
        return new TaskExecutionDetails(this.taskId, this.task, TaskManager.Status.CANCELLED, this.submitDate, this.startedDate, Optional.empty(), Optional.of(ZonedDateTime.now()), Optional.empty());
    }

    public static interface AdditionalInformation {
    }
}

