/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry.backoff;

import com.nurkiewicz.asyncretry.RetryContext;
import com.nurkiewicz.asyncretry.backoff.Backoff;
import com.nurkiewicz.asyncretry.backoff.BackoffWrapper;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;

public abstract class RandomBackoff
extends BackoffWrapper {
    private final Supplier<Random> randomSource;

    protected RandomBackoff(Backoff target) {
        this(target, ThreadLocalRandom::current);
    }

    protected RandomBackoff(Backoff target, Random randomSource) {
        this(target, () -> randomSource);
    }

    private RandomBackoff(Backoff target, Supplier<Random> randomSource) {
        super(target);
        this.randomSource = randomSource;
    }

    @Override
    public long delayMillis(RetryContext context) {
        long initialDelay = this.target.delayMillis(context);
        long randomDelay = this.addRandomJitter(initialDelay);
        return Math.max(randomDelay, 0L);
    }

    abstract long addRandomJitter(long var1);

    protected Random random() {
        return this.randomSource.get();
    }
}

