/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry.backoff;

import com.nurkiewicz.asyncretry.RetryContext;
import com.nurkiewicz.asyncretry.backoff.BoundedMaxBackoff;
import com.nurkiewicz.asyncretry.backoff.BoundedMinBackoff;
import com.nurkiewicz.asyncretry.backoff.FirstRetryNoDelayBackoff;
import com.nurkiewicz.asyncretry.backoff.FixedIntervalBackoff;
import com.nurkiewicz.asyncretry.backoff.ProportionalRandomBackoff;
import com.nurkiewicz.asyncretry.backoff.UniformRandomBackoff;

public interface Backoff {
    public static final Backoff DEFAULT = new FixedIntervalBackoff();

    public long delayMillis(RetryContext var1);

    default public Backoff withUniformJitter() {
        return new UniformRandomBackoff(this);
    }

    default public Backoff withUniformJitter(long range) {
        return new UniformRandomBackoff(this, range);
    }

    default public Backoff withProportionalJitter() {
        return new ProportionalRandomBackoff(this);
    }

    default public Backoff withProportionalJitter(double multiplier) {
        return new ProportionalRandomBackoff(this, multiplier);
    }

    default public Backoff withMinDelay(long minDelayMillis) {
        return new BoundedMinBackoff(this, minDelayMillis);
    }

    default public Backoff withMinDelay() {
        return new BoundedMinBackoff(this);
    }

    default public Backoff withMaxDelay(long maxDelayMillis) {
        return new BoundedMaxBackoff(this, maxDelayMillis);
    }

    default public Backoff withMaxDelay() {
        return new BoundedMaxBackoff(this);
    }

    default public Backoff withFirstRetryNoDelay() {
        return new FirstRetryNoDelayBackoff(this);
    }
}

