/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry;

import com.nurkiewicz.asyncretry.AsyncRetryContext;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.RetryJob;
import com.nurkiewicz.asyncretry.function.RetryCallable;
import java.util.concurrent.CompletableFuture;

class SyncRetryJob<V>
extends RetryJob<V> {
    private final RetryCallable<V> userTask;

    public SyncRetryJob(RetryCallable<V> userTask, AsyncRetryExecutor parent) {
        this(userTask, parent, new AsyncRetryContext(parent.getRetryPolicy()), new CompletableFuture());
    }

    public SyncRetryJob(RetryCallable<V> userTask, AsyncRetryExecutor parent, AsyncRetryContext context, CompletableFuture<V> future) {
        super(context, parent, future);
        this.userTask = userTask;
    }

    @Override
    public void run(long startTime) {
        try {
            V result = this.userTask.call(this.context);
            this.complete(result, System.currentTimeMillis() - startTime);
        }
        catch (Throwable t) {
            this.handleThrowable(t, System.currentTimeMillis() - startTime);
        }
    }

    @Override
    protected RetryJob<V> nextTask(AsyncRetryContext nextRetryContext) {
        return new SyncRetryJob<V>(this.userTask, this.parent, nextRetryContext, this.future);
    }
}

