/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry;

import com.nurkiewicz.asyncretry.AsyncRetryContext;
import com.nurkiewicz.asyncretry.RetryExecutor;
import com.nurkiewicz.asyncretry.function.RetryCallable;
import com.nurkiewicz.asyncretry.function.RetryRunnable;
import com.nurkiewicz.asyncretry.policy.RetryPolicy;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;

public enum SyncRetryExecutor implements RetryExecutor
{
    INSTANCE;

    private static final AsyncRetryContext RETRY_CONTEXT;

    @Override
    public CompletableFuture<Void> doWithRetry(RetryRunnable action) {
        try {
            action.run(RETRY_CONTEXT);
            return CompletableFuture.completedFuture(null);
        }
        catch (Exception e) {
            return SyncRetryExecutor.failedFuture(e);
        }
    }

    @Override
    public <V> CompletableFuture<V> getWithRetry(Callable<V> task) {
        try {
            return CompletableFuture.completedFuture(task.call());
        }
        catch (Exception e) {
            return SyncRetryExecutor.failedFuture(e);
        }
    }

    @Override
    public <V> CompletableFuture<V> getWithRetry(RetryCallable<V> task) {
        try {
            return CompletableFuture.completedFuture(task.call(RETRY_CONTEXT));
        }
        catch (Exception e) {
            return SyncRetryExecutor.failedFuture(e);
        }
    }

    @Override
    public <V> CompletableFuture<V> getFutureWithRetry(RetryCallable<CompletableFuture<V>> task) {
        try {
            return task.call(RETRY_CONTEXT);
        }
        catch (Exception e) {
            return SyncRetryExecutor.failedFuture(e);
        }
    }

    private static <T> CompletableFuture<T> failedFuture(Exception e) {
        CompletableFuture promise = new CompletableFuture();
        promise.completeExceptionally(e);
        return promise;
    }

    static {
        RETRY_CONTEXT = new AsyncRetryContext(RetryPolicy.DEFAULT);
    }
}

