/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry;

import com.nurkiewicz.asyncretry.AsyncRetryContext;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.RetryJob;
import com.nurkiewicz.asyncretry.function.RetryCallable;
import java.util.concurrent.CompletableFuture;

public class AsyncRetryJob<V>
extends RetryJob<V> {
    private final RetryCallable<CompletableFuture<V>> userTask;

    public AsyncRetryJob(RetryCallable<CompletableFuture<V>> userTask, AsyncRetryExecutor parent) {
        this(userTask, parent, new AsyncRetryContext(parent.getRetryPolicy()), new CompletableFuture());
    }

    public AsyncRetryJob(RetryCallable<CompletableFuture<V>> userTask, AsyncRetryExecutor parent, AsyncRetryContext context, CompletableFuture<V> future) {
        super(context, parent, future);
        this.userTask = userTask;
    }

    @Override
    public void run(long startTime) {
        try {
            this.userTask.call(this.context).handle((result, throwable) -> {
                long stopTime = System.currentTimeMillis() - startTime;
                if (throwable != null) {
                    this.handleThrowable((Throwable)throwable, stopTime);
                } else {
                    this.complete(result, stopTime);
                }
                return null;
            });
        }
        catch (Throwable t) {
            this.handleThrowable(t, System.currentTimeMillis() - startTime);
        }
    }

    @Override
    protected RetryJob<V> nextTask(AsyncRetryContext nextRetryContext) {
        return new AsyncRetryJob<V>(this.userTask, this.parent, nextRetryContext, this.future);
    }
}

