/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.hook;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class HookReturnCode {
    private final Action action;
    private final ConnectionStatus connectionStatus;

    public static HookReturnCode denySoft() {
        return HookReturnCode.connected(Action.DENYSOFT);
    }

    public static HookReturnCode deny() {
        return HookReturnCode.connected(Action.DENY);
    }

    public static HookReturnCode ok() {
        return HookReturnCode.connected(Action.OK);
    }

    public static HookReturnCode declined() {
        return HookReturnCode.connected(Action.DECLINED);
    }

    public static HookReturnCode connected(Action action) {
        return new HookReturnCode(action, ConnectionStatus.Connected);
    }

    public static HookReturnCode disconnected(Action action) {
        return new HookReturnCode(action, ConnectionStatus.Disconnected);
    }

    public HookReturnCode(Action action, ConnectionStatus connectionStatus) {
        this.action = action;
        this.connectionStatus = connectionStatus;
    }

    public Action getAction() {
        return this.action;
    }

    public ConnectionStatus getConnectionStatus() {
        return this.connectionStatus;
    }

    public boolean isDisconnected() {
        return this.connectionStatus == ConnectionStatus.Disconnected;
    }

    public final boolean equals(Object o) {
        if (o instanceof HookReturnCode) {
            HookReturnCode that = (HookReturnCode)o;
            return Objects.equals((Object)this.action, (Object)that.action) && Objects.equals((Object)this.connectionStatus, (Object)that.connectionStatus);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.action, this.connectionStatus});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("disconnection", (Object)this.connectionStatus).toString();
    }

    public static enum ConnectionStatus {
        Disconnected,
        Connected;

    }

    public static enum Action {
        OK,
        DENY,
        DENYSOFT,
        DECLINED,
        NONE;

        public static List<Action> ACTIVE_ACTIONS;

        static {
            ACTIVE_ACTIONS = ImmutableList.of((Object)((Object)DENY), (Object)((Object)DENYSOFT), (Object)((Object)OK));
        }
    }
}

