/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import java.util.Locale;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.RcptHook;

public abstract class AbstractSenderAuthIdentifyVerificationRcptHook
implements RcptHook {
    private static final HookResult INVALID_AUTH = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("503").smtpDescription(DSNStatus.getStatus(5, "7.1") + " Incorrect Authentication for Specified Email Address").build();

    @Override
    public HookResult doRcpt(SMTPSession session, MailAddress sender, MailAddress rcpt) {
        if (session.getUser() != null) {
            String authUser = session.getUser().toLowerCase(Locale.US);
            MailAddress senderAddress = (MailAddress)session.getAttachment("SENDER_ADDRESS", ProtocolSession.State.Transaction);
            String username = this.retrieveSender(sender, senderAddress);
            if (senderAddress == null || !authUser.equalsIgnoreCase(username) || !this.isLocalDomain(senderAddress.getDomain())) {
                return INVALID_AUTH;
            }
        }
        return HookResult.DECLINED;
    }

    public String retrieveSender(MailAddress sender, MailAddress senderAddress) {
        if (senderAddress != null && !sender.isNullSender()) {
            return this.getUser(senderAddress);
        }
        return null;
    }

    protected abstract boolean isLocalDomain(Domain var1);

    protected abstract String getUser(MailAddress var1);
}

