/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQPropertyConversionException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.message.LargeBodyEncoder;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.collections.TypedProperties;

public class ClientMessageImpl
extends CoreMessage
implements ClientMessageInternal {
    public static final SimpleString REPLYTO_HEADER_NAME = MessageUtil.REPLYTO_HEADER_NAME;
    private int deliveryCount;
    private ClientConsumerInternal consumer;
    private int flowControlSize = -1;
    private InputStream bodyInputStream;

    public ClientMessageImpl() {
    }

    public ClientMessageImpl(CoreMessageObjectPools coreMessageObjectPools) {
        super(coreMessageObjectPools);
    }

    protected ClientMessageImpl(ClientMessageImpl other) {
        super(other);
    }

    @Override
    public ClientMessageImpl setDurable(boolean durable) {
        super.setDurable(durable);
        return this;
    }

    @Override
    public ClientMessageImpl setExpiration(long expiration) {
        super.setExpiration(expiration);
        return this;
    }

    @Override
    public ClientMessageImpl setPriority(byte priority) {
        super.setPriority(priority);
        return this;
    }

    @Override
    public ClientMessageImpl setUserID(UUID userID) {
        return this;
    }

    public ClientMessageImpl(byte type, boolean durable, long expiration, long timestamp, byte priority, int initialMessageBufferSize, CoreMessageObjectPools coreMessageObjectPools) {
        super(coreMessageObjectPools);
        this.setType(type).setExpiration(expiration).setTimestamp(timestamp).setDurable(durable).setPriority(priority).initBuffer(initialMessageBufferSize);
    }

    public ClientMessageImpl(byte type, boolean durable, long expiration, long timestamp, byte priority, int initialMessageBufferSize) {
        this(type, durable, expiration, timestamp, priority, initialMessageBufferSize, null);
    }

    @Override
    public TypedProperties getProperties() {
        return this.checkProperties();
    }

    @Override
    public void onReceipt(ClientConsumerInternal consumer) {
        this.consumer = consumer;
    }

    @Override
    public ClientMessageImpl setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
        return this;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public ClientMessageImpl acknowledge() throws ActiveMQException {
        if (this.consumer != null) {
            this.consumer.acknowledge(this);
        }
        return this;
    }

    @Override
    public ClientMessageImpl individualAcknowledge() throws ActiveMQException {
        if (this.consumer != null) {
            this.consumer.individualAcknowledge(this);
        }
        return this;
    }

    @Override
    public void checkCompletion() throws ActiveMQException {
    }

    @Override
    public int getFlowControlSize() {
        if (this.flowControlSize < 0) {
            throw new IllegalStateException("Flow Control hasn't been set");
        }
        return this.flowControlSize;
    }

    @Override
    public void setFlowControlSize(int flowControlSize) {
        this.flowControlSize = flowControlSize;
    }

    @Override
    public boolean isLargeMessage() {
        return false;
    }

    @Override
    public boolean isCompressed() {
        return this.properties.getBooleanProperty(Message.HDR_LARGE_COMPRESSED);
    }

    @Override
    public int getBodySize() {
        return this.getBodyBuffer().writerIndex() - this.getBodyBuffer().readerIndex();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[messageID=" + this.messageID + ", durable=" + this.durable + ", address=" + this.getAddress() + ",userID=" + (this.getUserID() != null ? this.getUserID() : "null") + ",properties=" + this.getProperties().toString() + "]";
    }

    @Override
    public void saveToOutputStream(OutputStream out) throws ActiveMQException {
        try {
            byte[] readBuffer = new byte[this.getBodySize()];
            this.getBodyBuffer().readBytes(readBuffer);
            out.write(readBuffer);
            out.flush();
        }
        catch (IOException e) {
            throw ActiveMQClientMessageBundle.BUNDLE.errorSavingBody(e);
        }
    }

    @Override
    public ClientMessageImpl setOutputStream(OutputStream out) throws ActiveMQException {
        this.saveToOutputStream(out);
        return this;
    }

    @Override
    public boolean waitOutputStreamCompletion(long timeMilliseconds) throws ActiveMQException {
        return true;
    }

    @Override
    public void discardBody() {
    }

    @Override
    public InputStream getBodyInputStream() {
        return this.bodyInputStream;
    }

    @Override
    public ClientMessageImpl setBodyInputStream(InputStream bodyInputStream) {
        this.bodyInputStream = bodyInputStream;
        return this;
    }

    @Override
    public LargeBodyEncoder getBodyEncoder() throws ActiveMQException {
        return new DecodingContext();
    }

    @Override
    public ClientMessageImpl putBooleanProperty(SimpleString key, boolean value) {
        return (ClientMessageImpl)super.putBooleanProperty(key, value);
    }

    @Override
    public ClientMessageImpl putByteProperty(SimpleString key, byte value) {
        return (ClientMessageImpl)super.putByteProperty(key, value);
    }

    @Override
    public ClientMessageImpl putBytesProperty(SimpleString key, byte[] value) {
        return (ClientMessageImpl)super.putBytesProperty(key, value);
    }

    @Override
    public ClientMessageImpl putCharProperty(SimpleString key, char value) {
        return (ClientMessageImpl)super.putCharProperty(key, value);
    }

    @Override
    public ClientMessageImpl putCharProperty(String key, char value) {
        return (ClientMessageImpl)super.putCharProperty(key, value);
    }

    @Override
    public ClientMessageImpl putShortProperty(SimpleString key, short value) {
        return (ClientMessageImpl)super.putShortProperty(key, value);
    }

    @Override
    public ClientMessageImpl putIntProperty(SimpleString key, int value) {
        return (ClientMessageImpl)super.putIntProperty(key, value);
    }

    @Override
    public ClientMessageImpl putLongProperty(SimpleString key, long value) {
        return (ClientMessageImpl)super.putLongProperty(key, value);
    }

    @Override
    public ClientMessageImpl putFloatProperty(SimpleString key, float value) {
        return (ClientMessageImpl)super.putFloatProperty(key, value);
    }

    @Override
    public ClientMessageImpl putDoubleProperty(SimpleString key, double value) {
        return (ClientMessageImpl)super.putDoubleProperty(key, value);
    }

    @Override
    public ClientMessageImpl putStringProperty(SimpleString key, SimpleString value) {
        return (ClientMessageImpl)super.putStringProperty(key, value);
    }

    @Override
    public ClientMessageImpl putStringProperty(SimpleString key, String value) {
        return (ClientMessageImpl)super.putStringProperty(key, value);
    }

    @Override
    public ClientMessageImpl putObjectProperty(SimpleString key, Object value) throws ActiveMQPropertyConversionException {
        return (ClientMessageImpl)super.putObjectProperty(key, value);
    }

    @Override
    public ClientMessageImpl putObjectProperty(String key, Object value) throws ActiveMQPropertyConversionException {
        return (ClientMessageImpl)super.putObjectProperty(key, value);
    }

    @Override
    public ClientMessageImpl putBooleanProperty(String key, boolean value) {
        return (ClientMessageImpl)super.putBooleanProperty(key, value);
    }

    @Override
    public ClientMessageImpl putByteProperty(String key, byte value) {
        return (ClientMessageImpl)super.putByteProperty(key, value);
    }

    @Override
    public ClientMessageImpl putBytesProperty(String key, byte[] value) {
        return (ClientMessageImpl)super.putBytesProperty(key, value);
    }

    @Override
    public ClientMessageImpl putShortProperty(String key, short value) {
        return (ClientMessageImpl)super.putShortProperty(key, value);
    }

    @Override
    public ClientMessageImpl putIntProperty(String key, int value) {
        return (ClientMessageImpl)super.putIntProperty(key, value);
    }

    @Override
    public ClientMessageImpl putLongProperty(String key, long value) {
        return (ClientMessageImpl)super.putLongProperty(key, value);
    }

    @Override
    public ClientMessageImpl putFloatProperty(String key, float value) {
        return (ClientMessageImpl)super.putFloatProperty(key, value);
    }

    @Override
    public ClientMessageImpl putDoubleProperty(String key, double value) {
        return (ClientMessageImpl)super.putDoubleProperty(key, value);
    }

    @Override
    public ClientMessageImpl putStringProperty(String key, String value) {
        return (ClientMessageImpl)super.putStringProperty(key, value);
    }

    @Override
    public ClientMessageImpl writeBodyBufferBytes(byte[] bytes) {
        this.getBodyBuffer().writeBytes(bytes);
        return this;
    }

    @Override
    public ClientMessageImpl writeBodyBufferString(String string) {
        this.getBodyBuffer().writeString(string);
        return this;
    }

    @Override
    public Message copy() {
        return new ClientMessageImpl(this);
    }

    private final class DecodingContext
    implements LargeBodyEncoder {
        private DecodingContext() {
        }

        @Override
        public void open() {
            ClientMessageImpl.this.getBodyBuffer().readerIndex(0);
        }

        @Override
        public void close() {
        }

        @Override
        public long getLargeBodySize() {
            if (ClientMessageImpl.this.isLargeMessage()) {
                return ClientMessageImpl.this.getBodyBuffer().writerIndex();
            }
            return ClientMessageImpl.this.getBodyBuffer().writerIndex() - 4;
        }

        @Override
        public int encode(ByteBuffer bufferRead) throws ActiveMQException {
            ActiveMQBuffer buffer1 = ActiveMQBuffers.wrappedBuffer((ByteBuffer)bufferRead);
            return this.encode(buffer1, bufferRead.capacity());
        }

        @Override
        public int encode(ActiveMQBuffer bufferOut, int size) {
            byte[] bytes = new byte[size];
            ClientMessageImpl.this.buffer.readBytes(bytes);
            bufferOut.writeBytes(bytes, 0, size);
            return size;
        }
    }
}

