/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.file;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.core.Domain;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.rrt.lib.MappingSource;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.rrt.lib.RecipientRewriteTableUtil;

public class XMLRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private Map<MappingSource, String> mappings;

    protected void doConfigure(HierarchicalConfiguration arg0) throws ConfigurationException {
        String[] mapConf = arg0.getStringArray("mapping");
        this.mappings = Maps.newHashMap();
        if (mapConf != null && mapConf.length > 0) {
            for (String aMapConf : mapConf) {
                this.mappings.putAll(RecipientRewriteTableUtil.getXMLMappings((String)aMapConf));
            }
        } else {
            throw new ConfigurationException("No mapping configured");
        }
    }

    protected Mappings mapAddress(String user, Domain domain) {
        return (Mappings)Optional.ofNullable(this.mappings).map(mappings -> RecipientRewriteTableUtil.getTargetString((String)user, (Domain)domain, (Map)mappings)).map(MappingsImpl::fromRawString).orElse(MappingsImpl.empty());
    }

    public Mappings getUserDomainMappings(MappingSource source) {
        if (this.mappings == null) {
            return null;
        }
        String maps = this.mappings.get(source);
        if (maps != null) {
            return MappingsImpl.fromRawString((String)maps);
        }
        return null;
    }

    public Map<MappingSource, Mappings> getAllMappings() {
        if (this.mappings != null && this.mappings.size() > 0) {
            HashMap<MappingSource, Mappings> mappingsNew = new HashMap<MappingSource, Mappings>();
            for (MappingSource key : this.mappings.keySet()) {
                mappingsNew.put(key, (Mappings)MappingsImpl.fromRawString((String)this.mappings.get(key)));
            }
            return mappingsNew;
        }
        return ImmutableMap.of();
    }

    public void addMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only implementation");
    }

    public void removeMapping(MappingSource source, Mapping mapping) throws RecipientRewriteTableException {
        throw new RecipientRewriteTableException("Read-Only implementation");
    }
}

