/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailrepository.file;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepository;
import org.apache.james.server.core.MailImpl;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MBoxMailRepository
implements MailRepository,
Configurable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MBoxMailRepository.class);
    static final SimpleDateFormat dy = new SimpleDateFormat("EE MMM dd HH:mm:ss yyyy", Locale.US);
    static final String LOCKEXT = ".lock";
    static final String WORKEXT = ".work";
    static final int LOCKSLEEPDELAY = 2000;
    static final int MAXSLEEPTIMES = 100;
    static final long MLISTPRESIZEFACTOR = 10240L;
    static final long DEFAULTMLISTCAPACITY = 20L;
    private static boolean BUFFERING = true;
    private Hashtable<String, Long> mList = null;
    private String mboxFile;
    private boolean fifo;

    public void configure(HierarchicalConfiguration configuration) throws ConfigurationException {
        this.mList = null;
        BUFFERING = configuration.getBoolean("[@BUFFERING]", true);
        this.fifo = configuration.getBoolean("[@FIFO]", false);
        String destination = configuration.getString("[@destinationURL]");
        this.mboxFile = destination.charAt(destination.length() - 1) == '/' ? destination.substring("mbox://".length(), destination.lastIndexOf("/")) : destination.substring("mbox://".length());
        LOGGER.debug("MBoxMailRepository.destinationURL: {}", (Object)destination);
        String checkType = configuration.getString("[@type]");
        if (!checkType.equals("MAIL") && !checkType.equals("SPOOL")) {
            String exceptionString = "Attempt to configure MboxMailRepository as " + checkType;
            LOGGER.warn(exceptionString);
            throw new ConfigurationException(exceptionString);
        }
    }

    private String getRawMessage(MimeMessage mc) throws IOException, MessagingException {
        ByteArrayOutputStream rawMessage = new ByteArrayOutputStream();
        mc.writeTo((OutputStream)rawMessage);
        return rawMessage.toString();
    }

    private MimeMessage convertTextToMimeMessage(String emailBody) {
        MimeMessage mimeMessage = null;
        ByteArrayInputStream mb = new ByteArrayInputStream(emailBody.getBytes());
        Properties props = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)props);
        try {
            mimeMessage = new MimeMessage(session, (InputStream)mb);
        }
        catch (MessagingException e) {
            LOGGER.error("Unable to parse mime message!", (Throwable)e);
        }
        if (mimeMessage == null) {
            LOGGER.debug("Mime message is null");
        }
        return mimeMessage;
    }

    private String generateKeyValue(String emailBody) {
        return Hashing.sha256().hashUnencodedChars((CharSequence)emailBody).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeMessage parseMboxFile(RandomAccessFile ins, MessageAction messAct) {
        LOGGER.debug("Start parsing {}", (Object)this.mboxFile);
        try {
            CharSequence line;
            Pattern sepMatchPattern = Pattern.compile("^From (.*) (.*):(.*):(.*)$");
            boolean inMessage = false;
            StringBuffer messageBuffer = new StringBuffer();
            CharSequence previousMessageSeparator = null;
            long prevMessageStart = ins.getFilePointer();
            if (BUFFERING) {
                while ((line = ins.readLine()) != null) {
                    boolean foundSep = sepMatchPattern.matcher(line).matches();
                    if (foundSep && inMessage) {
                        MimeMessage endResult = messAct.messageAction((String)previousMessageSeparator, messageBuffer.toString(), prevMessageStart);
                        if (messAct.isComplete()) {
                            MimeMessage mimeMessage = endResult;
                            return mimeMessage;
                        }
                        previousMessageSeparator = line;
                        prevMessageStart = ins.getFilePointer() - (long)((String)line).length();
                        messageBuffer = new StringBuffer();
                        inMessage = true;
                    }
                    if (foundSep && !inMessage) {
                        previousMessageSeparator = line;
                        inMessage = true;
                    }
                    if (foundSep || !inMessage) continue;
                    messageBuffer.append((String)line).append("\n");
                }
            } else {
                int c;
                line = new StringBuffer();
                while ((c = ins.read()) != -1) {
                    if (c == 10) {
                        boolean foundSep = sepMatchPattern.matcher(line).matches();
                        if (foundSep && inMessage) {
                            MimeMessage endResult = messAct.messageAction((String)previousMessageSeparator, messageBuffer.toString(), prevMessageStart);
                            if (messAct.isComplete()) {
                                MimeMessage mimeMessage = endResult;
                                return mimeMessage;
                            }
                            previousMessageSeparator = ((StringBuffer)line).toString();
                            prevMessageStart = ins.getFilePointer() - (long)((StringBuffer)line).length();
                            messageBuffer = new StringBuffer();
                            inMessage = true;
                        }
                        if (foundSep && !inMessage) {
                            previousMessageSeparator = ((StringBuffer)line).toString();
                            inMessage = true;
                        }
                        if (!foundSep) {
                            messageBuffer.append((StringBuffer)line).append((char)c);
                        }
                        line = new StringBuffer();
                        continue;
                    }
                    ((StringBuffer)line).append((char)c);
                }
            }
            if (messageBuffer.length() != 0) {
                MimeMessage mimeMessage = messAct.messageAction((String)previousMessageSeparator, messageBuffer.toString(), prevMessageStart);
                return mimeMessage;
            }
        }
        catch (IOException ioEx) {
            LOGGER.error("Unable to write file (General I/O problem) {}", (Object)this.mboxFile, (Object)ioEx);
        }
        catch (PatternSyntaxException e) {
            LOGGER.error("Bad regex passed {}", (Object)this.mboxFile, (Object)e);
        }
        finally {
            LOGGER.debug("Finished parsing {}", (Object)this.mboxFile);
        }
        return null;
    }

    private MimeMessage findMessage(String key) {
        MimeMessage foundMessage = this.selectMessage(key);
        if (foundMessage == null) {
            this.mList = null;
            this.loadKeys();
            foundMessage = this.selectMessage(key);
        }
        return foundMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeMessage selectMessage(final String key) {
        MimeMessage foundMessage = null;
        if (this.mList == null || !this.mList.containsKey(key)) {
            LOGGER.debug("mList - key not found {}", (Object)this.mboxFile);
            return foundMessage;
        }
        long messageStart = this.mList.get(key);
        LOGGER.debug("Load message starting at offset {} from file {}", (Object)messageStart, (Object)this.mboxFile);
        RandomAccessFile ins = null;
        try {
            ins = new RandomAccessFile(this.mboxFile, "r");
            if (messageStart != 0L) {
                ins.seek(messageStart - 1L);
            }
            MessageAction op = new MessageAction(){

                @Override
                public boolean isComplete() {
                    return true;
                }

                @Override
                public MimeMessage messageAction(String messageSeparator, String bodyText, long messageStart) {
                    if (key.equals(MBoxMailRepository.this.generateKeyValue(bodyText))) {
                        LOGGER.debug("{} Located message. Returning MIME message", (Object)this.getClass().getName());
                        return MBoxMailRepository.this.convertTextToMimeMessage(bodyText);
                    }
                    return null;
                }
            };
            foundMessage = this.parseMboxFile(ins, op);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Unable to save(open) file (File not found) {}", (Object)this.mboxFile, (Object)e);
        }
        catch (IOException e) {
            LOGGER.error("Unable to write file (General I/O problem) {}", (Object)this.mboxFile, (Object)e);
        }
        finally {
            if (foundMessage == null) {
                LOGGER.debug("select - message not found {}", (Object)this.mboxFile);
            }
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close file (General I/O problem) {}", (Object)this.mboxFile, (Object)e);
                }
            }
        }
        return foundMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadKeys() {
        if (this.mList != null) {
            return;
        }
        RandomAccessFile ins = null;
        try {
            long initialCapacity;
            ins = new RandomAccessFile(this.mboxFile, "r");
            long l = initialCapacity = ins.length() > 10240L ? ins.length() / 10240L : 0L;
            if (initialCapacity < 20L) {
                initialCapacity = 20L;
            }
            if (initialCapacity > Integer.MAX_VALUE) {
                initialCapacity = 0x7FFFFFFEL;
            }
            this.mList = new Hashtable((int)initialCapacity);
            this.parseMboxFile(ins, new MessageAction(){

                @Override
                public boolean isComplete() {
                    return false;
                }

                @Override
                public MimeMessage messageAction(String messageSeparator, String bodyText, long messageStart) {
                    String key = MBoxMailRepository.this.generateKeyValue(bodyText);
                    MBoxMailRepository.this.mList.put(key, messageStart);
                    LOGGER.debug("Key {} at {}", (Object)key, (Object)messageStart);
                    return null;
                }
            });
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Unable to save(open) file (File not found) {}", (Object)this.mboxFile, (Object)e);
            this.mList = new Hashtable(20);
        }
        catch (IOException e) {
            LOGGER.error("Unable to write file (General I/O problem) {}", (Object)this.mboxFile, (Object)e);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to close file (General I/O problem) {}", (Object)this.mboxFile, (Object)e);
                }
            }
        }
    }

    public MailKey store(Mail mc) {
        LOGGER.debug("Will store message to file {}", (Object)this.mboxFile);
        this.mList = null;
        String fromHeader = null;
        String message = null;
        try {
            message = this.getRawMessage(mc.getMessage());
            fromHeader = mc.getMessage().getFrom() == null ? "From   " + dy.format(Calendar.getInstance().getTime()) : "From " + mc.getMessage().getFrom()[0] + " " + dy.format(Calendar.getInstance().getTime());
        }
        catch (IOException | MessagingException e) {
            LOGGER.error("Unable to parse mime message for {}", (Object)this.mboxFile, (Object)e);
        }
        try {
            RandomAccessFile saveFile = new RandomAccessFile(this.mboxFile, "rw");
            saveFile.seek(saveFile.length());
            saveFile.writeBytes(fromHeader + "\n");
            saveFile.writeBytes(message + "\n");
            saveFile.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Unable to save(open) file (File not found) {}", (Object)this.mboxFile, (Object)e);
        }
        catch (IOException e) {
            LOGGER.error("Unable to write file (General I/O problem) {}", (Object)this.mboxFile, (Object)e);
        }
        return MailKey.forMail((Mail)mc);
    }

    public Iterator<MailKey> list() {
        ArrayList<String> keys = this.loadKeysAsArray();
        if (!keys.isEmpty()) {
            this.findMessage(keys.iterator().next());
        }
        LOGGER.debug("{} keys to be iterated over.", (Object)keys.size());
        if (this.fifo) {
            Collections.sort(keys);
        }
        return keys.stream().map(MailKey::new).iterator();
    }

    private ArrayList<String> loadKeysAsArray() {
        this.loadKeys();
        return new ArrayList<String>(this.mList.keySet());
    }

    public Mail retrieve(MailKey key) throws MessagingException {
        this.loadKeys();
        MimeMessage foundMessage = this.findMessage(key.asString());
        if (foundMessage == null) {
            LOGGER.error("found message is null!");
            return null;
        }
        MailImpl res = new MailImpl();
        res.setMessage(foundMessage);
        res.setName(key.asString());
        LOGGER.debug("Retrieving entry for key {}", (Object)key);
        return res;
    }

    public void remove(Mail mail) {
        ArrayList<Mail> remArray = new ArrayList<Mail>();
        remArray.add(mail);
        this.remove(remArray);
    }

    private void lockMBox() throws Exception {
        String lockFileName = this.mboxFile + LOCKEXT;
        int sleepCount = 0;
        File mBoxLock = new File(lockFileName);
        if (!mBoxLock.createNewFile()) {
            while (!mBoxLock.createNewFile() && sleepCount < 100) {
                try {
                    LOGGER.debug("Waiting for lock on file {}", (Object)this.mboxFile);
                    Thread.sleep(2000L);
                    ++sleepCount;
                }
                catch (InterruptedException e) {
                    LOGGER.error("File lock wait for {} interrupted!", (Object)this.mboxFile, (Object)e);
                }
            }
            if (sleepCount >= 100) {
                throw new Exception("Unable to get lock on file " + this.mboxFile);
            }
        }
    }

    private void unlockMBox() {
        String lockFileName = this.mboxFile + LOCKEXT;
        File mBoxLock = new File(lockFileName);
        try {
            FileUtils.forceDelete((File)mBoxLock);
        }
        catch (IOException e) {
            LOGGER.error("{} Failed to delete lock file {}", (Object)this.getClass().getName(), (Object)lockFileName);
        }
    }

    public void remove(final Collection<Mail> mails) {
        LOGGER.debug("Removing entry for key {}", mails);
        try {
            RandomAccessFile ins = new RandomAccessFile(this.mboxFile, "r");
            final RandomAccessFile outputFile = new RandomAccessFile(this.mboxFile + WORKEXT, "rw");
            this.parseMboxFile(ins, new MessageAction(){

                @Override
                public boolean isComplete() {
                    return false;
                }

                @Override
                public MimeMessage messageAction(String messageSeparator, String bodyText, long messageStart) {
                    try {
                        String currentKey = MBoxMailRepository.this.generateKeyValue(bodyText);
                        boolean foundKey = false;
                        Iterator mailList = mails.iterator();
                        while (mailList.hasNext()) {
                            String key = ((Mail)mailList.next()).getName();
                            if (!key.equals(currentKey)) continue;
                            foundKey = true;
                            break;
                        }
                        if (!foundKey) {
                            outputFile.writeBytes(messageSeparator + "\n");
                            outputFile.writeBytes(bodyText);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to write file (General I/O problem) {}", (Object)MBoxMailRepository.this.mboxFile, (Object)e);
                    }
                    return null;
                }
            });
            ins.close();
            outputFile.close();
            File mbox = new File(this.mboxFile);
            FileUtils.forceDelete((File)mbox);
            mbox = new File(this.mboxFile + WORKEXT);
            if (!mbox.renameTo(new File(this.mboxFile))) {
                throw new IOException("Failed to rename file " + mbox + " -> " + this.mboxFile);
            }
            Iterator<Mail> mailList = mails.iterator();
            while (mailList.hasNext()) {
                String key = mailList.next().getName();
                this.mList.remove(key);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Unable to save(open) file (File not found) {}", (Object)this.mboxFile, (Object)e);
        }
        catch (IOException e) {
            LOGGER.error("Unable to write file (General I/O problem) {}", (Object)this.mboxFile, (Object)e);
        }
    }

    public void remove(MailKey key) throws MessagingException {
        this.loadKeys();
        try {
            this.lockMBox();
        }
        catch (Exception e) {
            LOGGER.error("Lock failed!", (Throwable)e);
            return;
        }
        ArrayList<Mail> keys = new ArrayList<Mail>();
        keys.add(this.retrieve(key));
        this.remove(keys);
        this.unlockMBox();
    }

    public boolean lock(MailKey key) {
        return false;
    }

    public boolean unlock(MailKey key) {
        return false;
    }

    public long size() {
        return this.loadKeysAsArray().size();
    }

    public void removeAll() throws MessagingException {
        ImmutableList.copyOf(this.list()).forEach(Throwing.consumer(this::remove).sneakyThrow());
    }

    public static interface MessageAction {
        public boolean isComplete();

        public MimeMessage messageAction(String var1, String var2, long var3);
    }
}

