/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.eventsourcing;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class EventId
implements Comparable<EventId> {
    private final int value;

    public static EventId fromSerialized(int value) {
        return new EventId(value);
    }

    public static EventId first() {
        return new EventId(0);
    }

    private EventId(int value) {
        Preconditions.checkArgument((value >= 0 ? 1 : 0) != 0, (Object)"EventId can not be negative");
        this.value = value;
    }

    public EventId next() {
        return new EventId(this.value + 1);
    }

    public Optional<EventId> previous() {
        if (this.value > 0) {
            return Optional.of(new EventId(this.value - 1));
        }
        return Optional.empty();
    }

    @Override
    public int compareTo(EventId o) {
        return Long.compare(this.value, o.value);
    }

    public final boolean equals(Object o) {
        if (o instanceof EventId) {
            EventId eventId = (EventId)o;
            return Objects.equals(this.value, eventId.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
    }

    public int serialize() {
        return this.value;
    }
}

