/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import org.apache.openjpa.persistence.query.AliasContext;
import org.apache.openjpa.persistence.query.CaseExpression;
import org.apache.openjpa.persistence.query.ConstantExpression;
import org.apache.openjpa.persistence.query.ElseExpression;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.Predicate;
import org.apache.openjpa.persistence.query.Visitable;
import org.apache.openjpa.persistence.query.WhenClause;

public class CaseExpressionImpl
implements CaseExpression,
Visitable {
    private LinkedList<WhenClause> _whens = new LinkedList();
    private final Object _caseOperand;

    public CaseExpressionImpl() {
        this(null);
    }

    public CaseExpressionImpl(Object caseOperand) {
        this._caseOperand = caseOperand;
    }

    @Override
    public Expression elseCase(Expression arg) {
        return new ElseExpression(this, arg);
    }

    @Override
    public Expression elseCase(String arg) {
        return new ElseExpression(this, new ConstantExpression(arg));
    }

    @Override
    public Expression elseCase(Number arg) {
        return new ElseExpression(this, new ConstantExpression(arg));
    }

    @Override
    public Expression elseCase(Date arg) {
        return new ElseExpression(this, new ConstantExpression(arg));
    }

    @Override
    public Expression elseCase(Calendar arg) {
        return new ElseExpression(this, new ConstantExpression(arg));
    }

    @Override
    public Expression elseCase(Class arg) {
        return new ElseExpression(this, new ConstantExpression(arg));
    }

    @Override
    public Expression elseCase(Enum<?> arg) {
        return new ElseExpression(this, new ConstantExpression(arg));
    }

    @Override
    public CaseExpression then(Expression then) {
        this.assertThenState();
        this._whens.getLast().setThen(then);
        return this;
    }

    @Override
    public CaseExpression then(Number then) {
        this.assertThenState();
        this._whens.getLast().setThen(then);
        return this;
    }

    @Override
    public CaseExpression then(String then) {
        this.assertThenState();
        this._whens.getLast().setThen(then);
        return this;
    }

    @Override
    public CaseExpression then(Date then) {
        this.assertThenState();
        this._whens.getLast().setThen(then);
        return this;
    }

    @Override
    public CaseExpression then(Calendar then) {
        this.assertThenState();
        this._whens.getLast().setThen(then);
        return this;
    }

    @Override
    public CaseExpression then(Class then) {
        this.assertThenState();
        this._whens.getLast().setThen(then);
        return this;
    }

    @Override
    public CaseExpression then(Enum<?> then) {
        this.assertThenState();
        this._whens.getLast().setThen(then);
        return this;
    }

    @Override
    public CaseExpression when(Predicate when) {
        this.assertWhenState();
        WhenClause clause = new WhenClause(when);
        this._whens.add(clause);
        return this;
    }

    @Override
    public CaseExpression when(Expression when) {
        this.assertWhenState();
        WhenClause clause = new WhenClause(when);
        this._whens.add(clause);
        return this;
    }

    @Override
    public CaseExpression when(Number when) {
        this.assertWhenState();
        WhenClause clause = new WhenClause(when);
        this._whens.add(clause);
        return this;
    }

    @Override
    public CaseExpression when(String when) {
        this.assertWhenState();
        WhenClause clause = new WhenClause(when);
        this._whens.add(clause);
        return this;
    }

    @Override
    public CaseExpression when(Date when) {
        this.assertWhenState();
        WhenClause clause = new WhenClause(when);
        this._whens.add(clause);
        return this;
    }

    @Override
    public CaseExpression when(Calendar when) {
        this.assertWhenState();
        WhenClause clause = new WhenClause(when);
        this._whens.add(clause);
        return this;
    }

    @Override
    public CaseExpression when(Class when) {
        this.assertWhenState();
        WhenClause clause = new WhenClause(when);
        this._whens.add(clause);
        return this;
    }

    @Override
    public CaseExpression when(Enum<?> when) {
        this.assertWhenState();
        WhenClause clause = new WhenClause(when);
        this._whens.add(clause);
        return this;
    }

    void assertWhenState() {
        boolean ok;
        boolean bl = ok = this._whens.isEmpty() || this._whens.getLast().hasThen();
        if (!ok) {
            throw new IllegalStateException("when() can not be called now");
        }
    }

    void assertThenState() {
        boolean ok;
        boolean bl = ok = !this._whens.isEmpty() && !this._whens.getLast().hasThen();
        if (!ok) {
            throw new IllegalStateException("then() can not be called now");
        }
    }

    @Override
    public String asExpression(AliasContext ctx) {
        StringBuilder tmp = new StringBuilder("CASE ");
        if (this._caseOperand != null) {
            tmp.append(this.toJPQL(ctx, this._caseOperand));
        }
        for (WhenClause when : this._whens) {
            tmp.append(when.toJPQL(ctx));
        }
        return tmp.toString();
    }

    @Override
    public String asProjection(AliasContext ctx) {
        return this.asExpression(ctx);
    }

    @Override
    public String asJoinable(AliasContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAliasHint(AliasContext ctx) {
        throw new UnsupportedOperationException();
    }

    String toJPQL(AliasContext ctx, Object o) {
        if (o instanceof Visitable) {
            return ((Visitable)o).asExpression(ctx);
        }
        return o.toString();
    }
}

