/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaFactory;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.SchemaTool;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.XMLSchemaParser;
import org.apache.openjpa.jdbc.schema.XMLSchemaSerializer;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.GeneralException;

public class TableSchemaFactory
implements SchemaFactory,
Configurable {
    public static final String ACTION_ADD = "add";
    public static final String ACTION_DROP = "drop";
    private static final Localizer _loc = Localizer.forPackage(TableSchemaFactory.class);
    private static boolean _refreshedTable = false;
    private JDBCConfiguration _conf = null;
    private Log _log = null;
    private DBIdentifier _table = DBIdentifier.newTable("OPENJPA_SCHEMA");
    private DBIdentifier _pkColumnName = DBIdentifier.newColumn("ID");
    private DBIdentifier _schemaColumnName = DBIdentifier.newColumn("SCHEMA_DEF");
    private Column _pkColumn = null;
    private Column _schemaColumn = null;

    public String getTable() {
        return this._table.getName();
    }

    public void setTable(String name) {
        this._table = DBIdentifier.newTable(name);
    }

    public void setTableName(String name) {
        this.setTable(name);
    }

    public void setPrimaryKeyColumn(String name) {
        this._pkColumnName = DBIdentifier.newColumn(name);
    }

    public String getPrimaryKeyColumn() {
        return this._pkColumnName.getName();
    }

    public void setSchemaColumn(String name) {
        this._schemaColumnName = DBIdentifier.newColumn(name);
    }

    public String getSchemaColumn() {
        return this._schemaColumnName.getName();
    }

    public JDBCConfiguration getConfiguration() {
        return this._conf;
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this._conf = (JDBCConfiguration)conf;
        this._log = this._conf.getLog("openjpa.jdbc.Schema");
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
        this.buildTable();
    }

    @Override
    public synchronized SchemaGroup readSchema() {
        String schema;
        block5: {
            schema = null;
            try {
                schema = this.readSchemaColumn();
            }
            catch (SQLException se) {
                if (!this._log.isWarnEnabled()) break block5;
                this._log.warn(_loc.get("bad-sch-read", se));
            }
        }
        if (schema == null) {
            return new SchemaGroup();
        }
        XMLSchemaParser parser = new XMLSchemaParser(this._conf);
        try {
            parser.parse(new StringReader(schema), this._schemaColumn.getQualifiedPath().toString());
        }
        catch (IOException ioe) {
            throw new GeneralException(ioe);
        }
        return parser.getSchemaGroup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void storeSchema(SchemaGroup schema) {
        XMLSchemaSerializer ser = new XMLSchemaSerializer(this._conf);
        ser.addAll(schema);
        StringWriter writer = new StringWriter();
        try {
            ser.serialize(writer, 0);
        }
        catch (IOException ioe) {
            throw new GeneralException(ioe);
        }
        String schemaStr = ((Object)writer).toString();
        try {
            this.writeSchemaColumn(schemaStr);
            return;
        }
        catch (SQLException se) {
            if (this._log.isWarnEnabled()) {
                this._log.warn(_loc.get("bad-sch-write-1", se));
            }
            Class<TableSchemaFactory> clazz = TableSchemaFactory.class;
            synchronized (TableSchemaFactory.class) {
                block13: {
                    if (!_refreshedTable) {
                        _refreshedTable = true;
                        try {
                            this.refreshTable();
                        }
                        catch (Exception e) {
                            if (!this._log.isWarnEnabled()) break block13;
                            this._log.warn(_loc.get("bad-sch-ref", e));
                        }
                    }
                }
                try {
                    this.writeSchemaColumn(schemaStr);
                }
                catch (Exception e) {
                    if (!this._log.isWarnEnabled()) throw SQLExceptions.getStore(se, this._conf.getDBDictionaryInstance());
                    this._log.warn(_loc.get("bad-sch-write-2"));
                    throw SQLExceptions.getStore(se, this._conf.getDBDictionaryInstance());
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTable() throws SQLException {
        if (this._log.isInfoEnabled()) {
            this._log.info(_loc.get("make-sch-table"));
        }
        SchemaTool tool = new SchemaTool(this._conf);
        tool.setIgnoreErrors(true);
        tool.createTable(this._pkColumn.getTable());
        Connection conn = this.getConnection();
        Statement stmnt = null;
        boolean wasAuto = true;
        try {
            wasAuto = conn.getAutoCommit();
            if (!wasAuto) {
                conn.setAutoCommit(true);
            }
            DBDictionary dict = this._conf.getDBDictionaryInstance();
            stmnt = conn.prepareStatement("INSERT INTO " + dict.getFullName(this._pkColumn.getTable(), false) + " (" + dict.getColumnDBName(this._pkColumn) + ", " + dict.getColumnDBName(this._schemaColumn) + ") VALUES (?, ?)");
            dict.setInt((PreparedStatement)stmnt, 1, 1, this._pkColumn);
            dict.setNull((PreparedStatement)stmnt, 2, this._schemaColumn.getType(), this._schemaColumn);
            dict.setTimeouts((PreparedStatement)stmnt, this._conf, true);
            stmnt.executeUpdate();
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (!wasAuto) {
                conn.setAutoCommit(false);
            }
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void dropTable() throws SQLException {
        if (this._log.isInfoEnabled()) {
            this._log.info(_loc.get("drop-sch-table"));
        }
        SchemaTool tool = new SchemaTool(this._conf);
        tool.setIgnoreErrors(true);
        tool.dropTable(this._pkColumn.getTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readSchemaColumn() throws SQLException {
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        SQLBuffer sel = new SQLBuffer(dict).append(this._schemaColumn);
        SQLBuffer where = new SQLBuffer(dict).append(this._pkColumn).append(" = ").appendValue(1, this._pkColumn);
        SQLBuffer tables = new SQLBuffer(dict).append(this._pkColumn.getTable());
        SQLBuffer select = dict.toSelect(sel, null, tables, where, null, null, null, false, false, 0L, Long.MAX_VALUE);
        Connection conn = this.getConnection();
        PreparedStatement stmnt = null;
        ResultSet rs = null;
        boolean wasAuto = true;
        try {
            String schema;
            wasAuto = conn.getAutoCommit();
            if (!wasAuto) {
                conn.setAutoCommit(true);
            }
            stmnt = select.prepareStatement(conn);
            dict.setQueryTimeout(stmnt, this._conf.getQueryTimeout());
            rs = stmnt.executeQuery();
            rs.next();
            String string = schema = this._schemaColumn.getType() == 2005 ? dict.getClobString(rs, 1) : dict.getString(rs, 1);
            return string;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (!wasAuto) {
                conn.setAutoCommit(false);
            }
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSchemaColumn(String schema) throws SQLException {
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        boolean embedded = dict.maxEmbeddedClobSize == -1;
        String update = embedded ? "UPDATE " + dict.getFullName(this._pkColumn.getTable(), false) + " SET " + dict.getColumnDBName(this._schemaColumn) + " = ?  WHERE " + dict.getColumnIdentifier(this._pkColumn) + " = ?" : "SELECT " + dict.getColumnDBName(this._schemaColumn) + " FROM " + dict.getFullName(this._pkColumn.getTable(), false) + " WHERE " + dict.getColumnDBName(this._pkColumn) + " = ?";
        Connection conn = this.getConnection();
        Statement stmnt = null;
        ResultSet rs = null;
        boolean wasAuto = true;
        try {
            wasAuto = conn.getAutoCommit();
            if (wasAuto != embedded) {
                conn.setAutoCommit(embedded);
            }
            if (embedded) {
                stmnt = conn.prepareStatement(update);
                if (schema == null) {
                    dict.setNull((PreparedStatement)stmnt, 1, this._schemaColumn.getType(), this._schemaColumn);
                } else if (this._schemaColumn.getType() == 2005) {
                    dict.setClobString((PreparedStatement)stmnt, 1, schema, this._schemaColumn);
                } else {
                    dict.setString((PreparedStatement)stmnt, 1, schema, this._schemaColumn);
                }
                dict.setInt((PreparedStatement)stmnt, 2, 1, this._pkColumn);
                dict.setTimeouts((PreparedStatement)stmnt, this._conf, true);
                stmnt.executeUpdate();
            } else {
                stmnt = conn.prepareStatement(update, 1004, 1008);
                dict.setInt((PreparedStatement)stmnt, 1, 1, this._pkColumn);
                dict.setTimeouts((PreparedStatement)stmnt, this._conf, true);
                rs = stmnt.executeQuery();
                rs.next();
                dict.putString(rs.getClob(1), schema);
                conn.commit();
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (wasAuto != embedded) {
                conn.setAutoCommit(wasAuto);
            }
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void buildTable() {
        QualifiedDBIdentifier path = QualifiedDBIdentifier.getPath(this._table);
        DBIdentifier tableName = path.getIdentifier();
        DBIdentifier schemaName = path.getSchemaName();
        if (DBIdentifier.isEmpty(schemaName)) {
            schemaName = Schemas.getNewTableSchemaIdentifier(this._conf);
        }
        SchemaGroup group = new SchemaGroup();
        Schema schema = group.addSchema(schemaName);
        Table table = schema.addTable(tableName);
        PrimaryKey pk = table.addPrimaryKey();
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        this._pkColumn = table.addColumn(dict.getValidColumnName(this._pkColumnName, table));
        this._pkColumn.setType(dict.getPreferredType(-6));
        this._pkColumn.setJavaType(5);
        pk.addColumn(this._pkColumn);
        this._schemaColumn = table.addColumn(dict.getValidColumnName(this._schemaColumnName, table));
        this._schemaColumn.setType(dict.getPreferredType(2005));
        this._schemaColumn.setJavaType(9);
    }

    private Connection getConnection() throws SQLException {
        return this._conf.getDataSource2(null).getConnection();
    }

    public static void main(String[] args) throws IOException, SQLException {
        Options opts = new Options();
        final String[] arguments = opts.setFromCmdLine(args);
        boolean ret = Configurations.runAgainstAllAnchors(opts, new Configurations.Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(Options opts) throws Exception {
                try (JDBCConfigurationImpl conf = new JDBCConfigurationImpl();){
                    boolean bl = TableSchemaFactory.run(conf, arguments, opts);
                    return bl;
                }
            }
        });
        if (!ret) {
            System.out.println(_loc.get("sch-usage"));
        }
    }

    public static boolean run(JDBCConfiguration conf, String[] args, Options opts) throws IOException, SQLException {
        String action = opts.removeProperty("action", "a", null);
        Configurations.populateConfiguration(conf, opts);
        return TableSchemaFactory.run(conf, action);
    }

    public static boolean run(JDBCConfiguration conf, String action) throws IOException, SQLException {
        TableSchemaFactory factory = new TableSchemaFactory();
        String props = Configurations.getProperties(conf.getSchemaFactory());
        Configurations.configureInstance((Object)factory, (Configuration)conf, props);
        if (ACTION_DROP.equals(action)) {
            factory.dropTable();
        } else if (ACTION_ADD.equals(action)) {
            factory.refreshTable();
        } else {
            return false;
        }
        return true;
    }
}

