/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;

public class NameSet
implements Serializable {
    private static final Localizer _loc = Localizer.forPackage(NameSet.class);
    private Set<DBIdentifier> _names = null;

    public boolean isNameTaken(String name) {
        return this.isNameTaken(DBIdentifier.toUpper(DBIdentifier.newDefault(name)));
    }

    public boolean isNameTaken(DBIdentifier name) {
        if (DBIdentifier.isEmpty(name)) {
            return true;
        }
        if (this._names == null) {
            return false;
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        return this._names.contains(sName);
    }

    protected void addName(String name, boolean validate) {
        this.addName(DBIdentifier.newIdentifier(name, DBIdentifier.DBIdentifierType.DEFAULT, true), validate);
    }

    protected void addName(DBIdentifier name, boolean validate) {
        if (DBIdentifier.isNull(name) || StringUtil.isEmpty(name.getName())) {
            if (validate) {
                throw new IllegalArgumentException(_loc.get("bad-name", name).getMessage());
            }
            return;
        }
        if (this._names == null) {
            this._names = new HashSet<DBIdentifier>();
        }
        DBIdentifier sName = DBIdentifier.toUpper(name);
        this._names.add(sName);
    }

    protected void removeName(String name) {
        if (name != null && this._names != null) {
            this.removeName(DBIdentifier.newIdentifier(name, DBIdentifier.DBIdentifierType.DEFAULT, true));
        }
    }

    protected void removeName(DBIdentifier name) {
        if (!DBIdentifier.isNull(name) && this._names != null) {
            DBIdentifier sName = DBIdentifier.toUpper(name);
            this._names.remove(sName);
        }
    }
}

