/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.LoggerFactory;

public class IsSenderInRRTLoop
extends GenericMatcher {
    private final RecipientRewriteTable recipientRewriteTable;

    @Inject
    public IsSenderInRRTLoop(RecipientRewriteTable recipientRewriteTable) {
        this.recipientRewriteTable = recipientRewriteTable;
    }

    public Collection<MailAddress> match(Mail mail) {
        try {
            if (mail.hasSender()) {
                this.recipientRewriteTable.getMappings(mail.getMaybeSender().get().getLocalPart(), mail.getMaybeSender().get().getDomain());
            }
        }
        catch (RecipientRewriteTable.TooManyMappingException e) {
            return mail.getRecipients();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(IsSenderInRRTLoop.class).warn("Error while executing RRT");
        }
        return ImmutableList.of();
    }
}

