/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.github.steveash.guavate.Guavate;
import java.util.Collection;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class IsMarkedAsSpam
extends GenericMatcher {
    private static final String YES = "yes";

    public String getMatcherInfo() {
        return "Has org.apache.james.spamassassin.status per recipient header with a Yes value";
    }

    public void init() throws MessagingException {
    }

    public Collection<MailAddress> match(Mail mail) {
        return (Collection)mail.getRecipients().stream().filter(recipient -> this.isMarkedAsSpam(mail, (MailAddress)recipient)).collect(Guavate.toImmutableList());
    }

    public boolean isMarkedAsSpam(Mail mail, MailAddress recipient) {
        return mail.getPerRecipientSpecificHeaders().getHeadersForRecipient(recipient).stream().filter(header -> header.getName().equals("org.apache.james.spamassassin.status")).anyMatch(header -> header.getValue().toLowerCase(Locale.US).startsWith(YES));
    }
}

