/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMatcher;

public class HasException
extends GenericMatcher {
    private Class<? extends Throwable> exceptionClass;

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Serializable exceptionValue = mail.getAttribute("org.apache.james.MailetError");
        if (exceptionValue != null && this.exceptionClass.isAssignableFrom(exceptionValue.getClass())) {
            return mail.getRecipients();
        }
        return ImmutableList.of();
    }

    public void init() throws MessagingException {
        try {
            String exceptionClassName = this.getCondition().trim();
            this.exceptionClass = HasException.castToThrowable(Class.forName(exceptionClassName));
        }
        catch (ClassNotFoundException e) {
            throw new MessagingException("Specified exception class not found.", (Exception)e);
        }
    }

    public String getMatcherInfo() {
        return "Specified Exception Has Occured Matcher";
    }

    private static Class<? extends Throwable> castToThrowable(Class<?> cls) throws MessagingException {
        if (Throwable.class.isAssignableFrom(cls)) {
            return cls;
        }
        throw new MessagingException("Specified class name is not a Throwable.");
    }
}

