/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.FetchGroupImpl;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.MessageResult;
import org.apache.james.mailbox.model.MessageResultIterator;
import org.apache.james.mailbox.model.search.MailboxNameExpression;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.mailbox.model.search.Wildcard;
import org.apache.james.transport.matchers.AbstractQuotaMatcher;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;

@Experimental
public abstract class AbstractStorageQuota
extends AbstractQuotaMatcher {
    private MailboxManager manager;
    private UsersRepository localUsers;

    @Inject
    public void setMailboxManager(@Named(value="mailboxmanager") MailboxManager manager) {
        this.manager = manager;
    }

    @Inject
    public void setUsersRepository(UsersRepository localUsers) {
        this.localUsers = localUsers;
    }

    @Override
    protected boolean isRecipientChecked(MailAddress recipient) throws MessagingException {
        MailetContext mailetContext = this.getMailetContext();
        return super.isRecipientChecked(recipient) && mailetContext.isLocalEmail(recipient);
    }

    @Override
    protected long getUsed(MailAddress recipient, Mail ignored) throws MessagingException {
        long size = 0L;
        try {
            String username;
            try {
                username = this.localUsers.getUser(recipient).toLowerCase(Locale.US);
            }
            catch (UsersRepositoryException e) {
                throw new MessagingException("Unable to access UsersRepository", (Exception)((Object)e));
            }
            MailboxSession session = this.manager.createSystemSession(username);
            this.manager.startProcessingRequest(session);
            List mList = this.manager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).expression((MailboxNameExpression)Wildcard.INSTANCE).build(), session);
            for (MailboxMetaData aMList : mList) {
                MessageManager mailbox = this.manager.getMailbox(aMList.getPath(), session);
                MessageResultIterator results = mailbox.getMessages(MessageRange.all(), FetchGroupImpl.MINIMAL, session);
                while (results.hasNext()) {
                    size += ((MessageResult)results.next()).getSize();
                }
            }
            this.manager.endProcessingRequest(session);
            this.manager.logout(session, true);
        }
        catch (BadCredentialsException e) {
            throw new MessagingException("Unable to authenticate to mailbox", (Exception)((Object)e));
        }
        catch (MailboxException e) {
            throw new MessagingException("Unable to get used space from mailbox", (Exception)((Object)e));
        }
        return size;
    }
}

