/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.sql.DataSource;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.model.JamesUser;
import org.apache.james.util.sql.JDBCUtil;
import org.apache.james.util.sql.SqlResources;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public abstract class AbstractSQLWhitelistMatcher
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSQLWhitelistMatcher.class);
    private UsersRepository localusers;
    protected DataSource datasource;
    protected JDBCUtil jdbcUtil;
    private final Map<String, String> sqlParameters = new HashMap<String, String>();
    protected final JDBCUtil theJDBCUtil = new JDBCUtil();
    protected final SqlResources sqlQueries = new SqlResources();
    private FileSystem fs;

    @Inject
    public void setDataSource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Inject
    public void setUsersRepository(UsersRepository localusers) {
        this.localusers = localusers;
    }

    @Inject
    public void setJdbcUtil(JDBCUtil jdbcUtil) {
        this.jdbcUtil = jdbcUtil;
    }

    private Map<String, String> getSqlParameters() {
        return this.sqlParameters;
    }

    @Inject
    public void setFilesystem(FileSystem fs) {
        this.fs = fs;
    }

    public void init() throws MessagingException {
        String repositoryPath = null;
        StringTokenizer st = new StringTokenizer(this.getCondition(), ", \t", false);
        if (st.hasMoreTokens()) {
            repositoryPath = st.nextToken().trim();
        }
        if (repositoryPath == null) {
            throw new MessagingException("repositoryPath is null");
        }
        LOGGER.info("repositoryPath: {}", (Object)repositoryPath);
        try {
            this.initSqlQueries(this.datasource.getConnection(), this.getMailetContext());
        }
        catch (Exception e) {
            throw new MessagingException("Exception initializing queries", e);
        }
        super.init();
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        if (!mail.hasSender()) {
            return null;
        }
        MailAddress senderMailAddress = mail.getMaybeSender().get();
        if (this.getMailetContext().isLocalEmail(senderMailAddress)) {
            return null;
        }
        String senderUser = senderMailAddress.getLocalPart();
        senderUser = senderUser.toLowerCase(Locale.US);
        Collection recipients = mail.getRecipients();
        HashSet<MailAddress> inWhiteList = new HashSet<MailAddress>();
        for (MailAddress recipientMailAddress : recipients) {
            String recipientUser = recipientMailAddress.getLocalPart().toLowerCase(Locale.US);
            Domain recipientHost = recipientMailAddress.getDomain();
            if (!this.getMailetContext().isLocalServer(recipientHost)) continue;
            recipientUser = this.getPrimaryName(recipientUser);
            if (!this.matchedWhitelist(recipientMailAddress, mail)) continue;
            inWhiteList.add(recipientMailAddress);
        }
        return inWhiteList;
    }

    protected abstract boolean matchedWhitelist(MailAddress var1, Mail var2) throws MessagingException;

    protected String getPrimaryName(String originalUsername) {
        String username;
        try {
            username = originalUsername;
            JamesUser user = (JamesUser)this.localusers.getUserByName(username);
            if (user.getAliasing()) {
                username = user.getAlias();
            }
        }
        catch (Exception e) {
            username = originalUsername;
        }
        return username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSqlQueries(Connection conn, MailetContext mailetContext) throws Exception {
        try {
            if (conn.getAutoCommit()) {
                conn.setAutoCommit(false);
            }
            File sqlFile = this.fs.getFile("classpath:sqlResources.xml");
            this.sqlQueries.init(sqlFile, this.getSQLSectionName(), conn, this.getSqlParameters());
            this.checkTables(conn);
        }
        finally {
            this.theJDBCUtil.closeJDBCConnection(conn);
        }
    }

    protected abstract String getTableName();

    protected abstract String getTableCreateQueryName();

    private void checkTables(Connection conn) throws SQLException {
        boolean dbUpdated = this.createTable(conn, this.getTableName(), this.getTableCreateQueryName());
        if (conn != null && dbUpdated && !conn.getAutoCommit()) {
            conn.commit();
            dbUpdated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createTable(Connection conn, String tableNameSqlStringName, String createSqlStringName) throws SQLException {
        String tableName = this.sqlQueries.getSqlString(tableNameSqlStringName, true);
        DatabaseMetaData dbMetaData = conn.getMetaData();
        if (this.theJDBCUtil.tableExists(dbMetaData, tableName)) {
            return false;
        }
        PreparedStatement createStatement = null;
        try {
            createStatement = conn.prepareStatement(this.sqlQueries.getSqlString(createSqlStringName, true));
            createStatement.execute();
            LOGGER.info("Created table '{}' using sqlResources string '{}'.", (Object)tableName, (Object)createSqlStringName);
        }
        catch (Throwable throwable) {
            this.theJDBCUtil.closeJDBCStatement(createStatement);
            throw throwable;
        }
        this.theJDBCUtil.closeJDBCStatement((Statement)createStatement);
        return true;
    }

    protected abstract String getSQLSectionName();
}

