/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.james.core.MailAddress;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.StringUtils;

public class AddressExtractor {
    private static final boolean ENFORCE_RFC822_SYNTAX = false;
    private final MailetContext mailetContext;
    private final List<String> allowedSpecials;

    public static Builder withContext(MailetContext mailetContext) {
        return new Builder(mailetContext);
    }

    private AddressExtractor(MailetContext mailetContext, List<String> allowedSpecials) {
        this.mailetContext = mailetContext;
        this.allowedSpecials = allowedSpecials;
    }

    private List<MailAddress> extract(Optional<String> maybeAddressList) throws MessagingException {
        if (!maybeAddressList.isPresent()) {
            return ImmutableList.of();
        }
        String addressList = maybeAddressList.get();
        try {
            return this.toMailAddresses((List<InternetAddress>)ImmutableList.copyOf((Object[])InternetAddress.parse((String)addressList, (boolean)false)));
        }
        catch (AddressException e) {
            throw new MessagingException("Exception thrown parsing: " + addressList, (Exception)((Object)e));
        }
    }

    private List<MailAddress> toMailAddresses(List<InternetAddress> addresses) throws MessagingException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (InternetAddress address : addresses) {
            builder.add((Object)this.toMailAddress(address));
        }
        return builder.build();
    }

    private MailAddress toMailAddress(InternetAddress address) throws MessagingException {
        try {
            Optional<MailAddress> specialAddress = this.getSpecialAddress(address.getAddress());
            if (specialAddress.isPresent()) {
                return specialAddress.get();
            }
            return new MailAddress(address);
        }
        catch (Exception e) {
            throw new MessagingException("Exception thrown parsing: " + address.getAddress());
        }
    }

    private Optional<MailAddress> getSpecialAddress(String addressString) throws MessagingException {
        if (Strings.isNullOrEmpty((String)addressString)) {
            return Optional.empty();
        }
        Optional<MailAddress> specialAddress = this.asSpecialAddress(addressString);
        if (specialAddress.isPresent()) {
            if (!this.isAllowed(addressString, this.allowedSpecials)) {
                throw new MessagingException("Special (\"magic\") address found not allowed: " + addressString + ", allowed values are \"" + StringUtils.listToString(this.allowedSpecials) + "\"");
            }
            return specialAddress;
        }
        return Optional.empty();
    }

    private Optional<MailAddress> asSpecialAddress(String addressString) {
        String lowerCaseTrimed = addressString.toLowerCase(Locale.US).trim();
        if (lowerCaseTrimed.equals("postmaster")) {
            return Optional.of(this.mailetContext.getPostmaster());
        }
        if (lowerCaseTrimed.equals("sender")) {
            return Optional.of(SpecialAddress.SENDER);
        }
        if (lowerCaseTrimed.equals("reversepath")) {
            return Optional.of(SpecialAddress.REVERSE_PATH);
        }
        if (lowerCaseTrimed.equals("from")) {
            return Optional.of(SpecialAddress.FROM);
        }
        if (lowerCaseTrimed.equals("replyto")) {
            return Optional.of(SpecialAddress.REPLY_TO);
        }
        if (lowerCaseTrimed.equals("to")) {
            return Optional.of(SpecialAddress.TO);
        }
        if (lowerCaseTrimed.equals("recipients")) {
            return Optional.of(SpecialAddress.RECIPIENTS);
        }
        if (lowerCaseTrimed.equals("delete")) {
            return Optional.of(SpecialAddress.DELETE);
        }
        if (lowerCaseTrimed.equals("unaltered")) {
            return Optional.of(SpecialAddress.UNALTERED);
        }
        if (lowerCaseTrimed.equals("null")) {
            return Optional.of(SpecialAddress.NULL);
        }
        return Optional.empty();
    }

    private boolean isAllowed(String addressString, List<String> allowedSpecials) {
        return allowedSpecials.stream().anyMatch(allowedSpecial -> addressString.equals(allowedSpecial.toLowerCase(Locale.US).trim()));
    }

    public static class Builder {
        private MailetContext mailetContext;
        private List<String> allowedSpecials;

        public Builder(MailetContext mailetContext) {
            this.mailetContext = mailetContext;
        }

        public Builder allowedSpecials(List<String> allowedSpecials) {
            this.allowedSpecials = allowedSpecials;
            return this;
        }

        public List<MailAddress> extract(Optional<String> addressList) throws MessagingException {
            this.checkParameters();
            return new AddressExtractor(this.mailetContext, this.allowedSpecials).extract(addressList);
        }

        public Optional<MailAddress> getSpecialAddress(String addressString) throws MessagingException {
            this.checkParameters();
            return new AddressExtractor(this.mailetContext, this.allowedSpecials).getSpecialAddress(addressString);
        }

        private void checkParameters() {
            Preconditions.checkNotNull((Object)this.mailetContext, (Object)"'mailetContext' is mandatory");
            Preconditions.checkNotNull(this.allowedSpecials, (Object)"'allowedSpecials' is mandatory");
        }
    }
}

