/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.delivery;

import com.google.common.base.Strings;
import java.io.InputStream;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.BadCredentialsException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.server.core.MimeMessageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxAppender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxAppender.class);
    private final MailboxManager mailboxManager;

    public MailboxAppender(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public ComposedMessageId append(MimeMessage mail, String user, String folder) throws MessagingException {
        MailboxSession session = this.createMailboxSession(user);
        return this.append(mail, user, this.useSlashAsSeparator(folder, session), session);
    }

    private String useSlashAsSeparator(String urlPath, MailboxSession session) throws MessagingException {
        String destination = urlPath.replace('/', session.getPathDelimiter());
        if (Strings.isNullOrEmpty((String)destination)) {
            throw new MessagingException("Mail can not be delivered to empty folder");
        }
        if (destination.charAt(0) == session.getPathDelimiter()) {
            destination = destination.substring(1);
        }
        return destination;
    }

    private ComposedMessageId append(MimeMessage mail, String user, String folder, MailboxSession session) throws MessagingException {
        this.mailboxManager.startProcessingRequest(session);
        try {
            MailboxPath mailboxPath = MailboxPath.forUser((String)user, (String)folder);
            ComposedMessageId composedMessageId = this.appendMessageToMailbox(mail, session, mailboxPath);
            return composedMessageId;
        }
        catch (MailboxException e) {
            throw new MessagingException("Unable to access mailbox.", (Exception)((Object)e));
        }
        finally {
            this.closeProcessing(session);
        }
    }

    private ComposedMessageId appendMessageToMailbox(MimeMessage mail, MailboxSession session, MailboxPath path) throws MailboxException, MessagingException {
        this.createMailboxIfNotExist(session, path);
        MessageManager mailbox = this.mailboxManager.getMailbox(path, session);
        if (mailbox == null) {
            throw new MessagingException("Mailbox " + path + " for user " + session.getUser().getUserName() + " was not found on this server.");
        }
        return mailbox.appendMessage(MessageManager.AppendCommand.builder().recent().build((InputStream)new MimeMessageInputStream(mail)), session);
    }

    private void createMailboxIfNotExist(MailboxSession session, MailboxPath path) throws MailboxException {
        if (!this.mailboxManager.mailboxExists(path, session)) {
            try {
                this.mailboxManager.createMailbox(path, session);
            }
            catch (MailboxExistsException e) {
                LOGGER.info("Mailbox {} have been created concurrently", (Object)path);
            }
        }
    }

    public MailboxSession createMailboxSession(String user) throws MessagingException {
        try {
            return this.mailboxManager.createSystemSession(user);
        }
        catch (BadCredentialsException e) {
            throw new MessagingException("Unable to authenticate to mailbox", (Exception)((Object)e));
        }
        catch (MailboxException e) {
            throw new MessagingException("Can not access mailbox", (Exception)((Object)e));
        }
    }

    private void closeProcessing(MailboxSession session) throws MessagingException {
        session.close();
        try {
            try {
                this.mailboxManager.logout(session, true);
            }
            catch (MailboxException e) {
                throw new MessagingException("Can logout from mailbox", (Exception)((Object)e));
            }
        }
        finally {
            this.mailboxManager.endProcessingRequest(session);
        }
    }
}

