/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.delivery;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.server.core.MailImpl;
import org.apache.james.transport.mailets.delivery.MailStore;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.apache.mailet.PerRecipientHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailDispatcher.class);
    public static final String[] NO_HEADERS = new String[0];
    private final MailStore mailStore;
    private final boolean consume;
    private final MailetContext mailetContext;

    public static Builder builder() {
        return new Builder();
    }

    private MailDispatcher(MailStore mailStore, boolean consume, MailetContext mailetContext) {
        this.mailStore = mailStore;
        this.consume = consume;
        this.mailetContext = mailetContext;
    }

    public void dispatch(Mail mail) throws MessagingException {
        List<MailAddress> errors = this.customizeHeadersAndDeliver(mail);
        if (!errors.isEmpty()) {
            MailImpl newMail = MailImpl.builder().sender(mail.getMaybeSender()).recipients(errors).mimeMessage(mail.getMessage()).state("error").build();
            this.mailetContext.sendMail((Mail)newMail);
        }
        if (this.consume) {
            mail.setState("ghost");
        }
    }

    private List<MailAddress> customizeHeadersAndDeliver(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        message.setHeader("Return-Path", mail.getMaybeSender().asPrettyString());
        List<MailAddress> errors = this.deliver(mail, message);
        return errors;
    }

    private List<MailAddress> deliver(Mail mail, MimeMessage message) {
        ArrayList<MailAddress> errors = new ArrayList<MailAddress>();
        for (MailAddress recipient : mail.getRecipients()) {
            try {
                Map<String, List<String>> savedHeaders = this.saveHeaders(mail, recipient);
                this.addSpecificHeadersForRecipient(mail, message, recipient);
                this.mailStore.storeMail(recipient, mail);
                this.restoreHeaders(mail.getMessage(), savedHeaders);
            }
            catch (Exception ex) {
                LOGGER.error("Error while storing mail.", (Throwable)ex);
                errors.add(recipient);
            }
        }
        return errors;
    }

    private Map<String, List<String>> saveHeaders(Mail mail, MailAddress recipient) throws MessagingException {
        ImmutableMap.Builder backup = ImmutableMap.builder();
        Collection headersToSave = mail.getPerRecipientSpecificHeaders().getHeaderNamesForRecipient(recipient);
        for (String headerName : headersToSave) {
            ImmutableList values = ImmutableList.copyOf((Object[])Optional.ofNullable(mail.getMessage().getHeader(headerName)).orElse(NO_HEADERS));
            backup.put((Object)headerName, (Object)values);
        }
        return backup.build();
    }

    private void restoreHeaders(MimeMessage mimeMessage, Map<String, List<String>> savedHeaders) throws MessagingException {
        for (Map.Entry<String, List<String>> header : savedHeaders.entrySet()) {
            String name = header.getKey();
            mimeMessage.removeHeader(name);
            for (String value : header.getValue()) {
                mimeMessage.addHeader(name, value);
            }
        }
    }

    private void addSpecificHeadersForRecipient(Mail mail, MimeMessage message, MailAddress recipient) throws MessagingException {
        for (PerRecipientHeaders.Header header : mail.getPerRecipientSpecificHeaders().getHeadersForRecipient(recipient)) {
            message.addHeader(header.getName(), header.getValue());
        }
    }

    public static class Builder {
        public static final boolean CONSUME = true;
        private MailStore mailStore;
        private Optional<Boolean> consume = Optional.empty();
        private MailetContext mailetContext;

        public Builder consume(boolean consume) {
            this.consume = Optional.of(consume);
            return this;
        }

        public Builder mailStore(MailStore mailStore) {
            this.mailStore = mailStore;
            return this;
        }

        public Builder mailetContext(MailetContext mailetContext) {
            this.mailetContext = mailetContext;
            return this;
        }

        public MailDispatcher build() {
            Preconditions.checkNotNull((Object)this.mailStore);
            Preconditions.checkNotNull((Object)this.mailetContext);
            return new MailDispatcher(this.mailStore, this.consume.orElse(true), this.mailetContext);
        }
    }
}

