/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import java.io.Serializable;
import java.util.Optional;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.base.GenericMailet;

public class WithPriority
extends GenericMailet {
    private int priority;

    public String getMailetInfo() {
        return "With Priority Mailet";
    }

    public void init() throws MessagingException {
        this.priority = Optional.ofNullable(this.getInitParameter("priority", null)).map(Integer::valueOf).orElseThrow(() -> new IllegalArgumentException("'priority' init parameter is compulsory"));
        if (this.priority < 0 || this.priority > 9) {
            throw new IllegalArgumentException("Invalid priority: Priority should be from 0 to 9");
        }
    }

    public void service(Mail mail) throws MessagingException {
        mail.setAttribute("MAIL_PRIORITY", (Serializable)Integer.valueOf(this.priority));
    }
}

