/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.spamassassin.SpamAssassinInvoker;
import org.apache.james.spamassassin.SpamAssassinResult;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.util.Port;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.GenericMailet;
import org.apache.mailet.base.MailetUtil;

public class SpamAssassin
extends GenericMailet {
    public static final String SPAMD_HOST = "spamdHost";
    public static final String SPAMD_PORT = "spamdPort";
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 783;
    private final MetricFactory metricFactory;
    private final UsersRepository usersRepository;
    private String spamdHost;
    private int spamdPort;

    @Inject
    public SpamAssassin(MetricFactory metricFactory, UsersRepository usersRepository) {
        this.metricFactory = metricFactory;
        this.usersRepository = usersRepository;
    }

    public void init() throws MessagingException {
        this.spamdHost = Optional.ofNullable(this.getInitParameter(SPAMD_HOST)).filter(s -> !Strings.isNullOrEmpty((String)s)).orElse(DEFAULT_HOST);
        this.spamdPort = MailetUtil.getInitParameterAsStrictlyPositiveInteger((String)this.getInitParameter(SPAMD_PORT), (int)783);
        Port.assertValid((int)this.spamdPort);
    }

    public void service(Mail mail) throws MessagingException {
        MimeMessage message = mail.getMessage();
        SpamAssassinInvoker sa = new SpamAssassinInvoker(this.metricFactory, this.spamdHost, this.spamdPort);
        mail.getRecipients().forEach(Throwing.consumer(recipient -> this.querySpamAssassin(mail, message, sa, (MailAddress)recipient)).sneakyThrow());
    }

    private void querySpamAssassin(Mail mail, MimeMessage message, SpamAssassinInvoker sa, MailAddress recipient) throws MessagingException, UsersRepositoryException {
        SpamAssassinResult result = sa.scanMail(message, this.usersRepository.getUser(recipient));
        for (String key : result.getHeadersAsAttribute().keySet()) {
            mail.addSpecificHeaderForRecipient(PerRecipientHeaders.Header.builder().name(key).value((String)result.getHeadersAsAttribute().get(key)).build(), recipient);
        }
    }

    public String getMailetInfo() {
        return "Checks message against SpamAssassin";
    }

    @VisibleForTesting
    String getSpamdHost() {
        return this.spamdHost;
    }

    @VisibleForTesting
    int getSpamdPort() {
        return this.spamdPort;
    }
}

