/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.mail.internet.ParseException;
import org.apache.james.core.MailAddress;
import org.apache.james.user.api.model.User;
import org.apache.james.user.jdbc.AbstractJdbcUsersRepository;
import org.apache.james.user.lib.model.DefaultJamesUser;
import org.apache.james.user.lib.model.DefaultUser;

@Deprecated
public class JamesUsersJdbcRepository
extends AbstractJdbcUsersRepository {
    @Override
    protected User readUserFromResultSet(ResultSet rsUsers) throws SQLException {
        String username = rsUsers.getString(1);
        String pwdHash = rsUsers.getString(2);
        String pwdAlgorithm = rsUsers.getString(3);
        boolean useForwarding = rsUsers.getBoolean(4);
        String forwardingDestination = rsUsers.getString(5);
        boolean useAlias = rsUsers.getBoolean(6);
        String alias = rsUsers.getString(7);
        MailAddress forwardAddress = null;
        if (forwardingDestination != null) {
            try {
                forwardAddress = new MailAddress(forwardingDestination);
            }
            catch (ParseException pe) {
                String exceptionBuffer = "Invalid mail address in database: " + forwardingDestination + ", for user " + username + ".";
                throw new RuntimeException(exceptionBuffer);
            }
        }
        DefaultJamesUser user = new DefaultJamesUser(username, pwdHash, pwdAlgorithm);
        user.setForwarding(useForwarding);
        user.setForwardingDestination(forwardAddress);
        user.setAliasing(useAlias);
        user.setAlias(alias);
        return user;
    }

    @Override
    protected void setUserForInsertStatement(User user, PreparedStatement userInsert) throws SQLException {
        this.setUserForStatement(user, userInsert, false);
    }

    @Override
    protected void setUserForUpdateStatement(User user, PreparedStatement userUpdate) throws SQLException {
        this.setUserForStatement(user, userUpdate, true);
    }

    private void setUserForStatement(User user, PreparedStatement stmt, boolean userNameLast) throws SQLException {
        DefaultJamesUser jamesUser;
        int nameIndex = 1;
        int colOffset = 1;
        if (userNameLast) {
            nameIndex = 7;
            colOffset = 0;
        }
        if (user instanceof DefaultJamesUser) {
            jamesUser = (DefaultJamesUser)user;
        } else if (user instanceof DefaultUser) {
            DefaultUser aUser = (DefaultUser)user;
            jamesUser = new DefaultJamesUser(aUser.getUserName(), aUser.getHashedPassword(), aUser.getHashAlgorithm());
        } else {
            throw new RuntimeException("An unknown implementation of User was found. This implementation cannot be persisted to a UsersJDBCRepsitory.");
        }
        stmt.setString(nameIndex, jamesUser.getUserName());
        stmt.setString(1 + colOffset, jamesUser.getHashedPassword());
        stmt.setString(2 + colOffset, jamesUser.getHashAlgorithm());
        stmt.setInt(3 + colOffset, jamesUser.getForwarding() ? 1 : 0);
        MailAddress forwardAddress = jamesUser.getForwardingDestination();
        String forwardDestination = null;
        if (forwardAddress != null) {
            forwardDestination = forwardAddress.toString();
        }
        stmt.setString(4 + colOffset, forwardDestination);
        stmt.setInt(5 + colOffset, jamesUser.getAliasing() ? 1 : 0);
        stmt.setString(6 + colOffset, jamesUser.getAlias());
    }
}

