/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.lib.netty;

import java.io.FileInputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.lib.jmx.ServerMBean;
import org.apache.james.protocols.lib.netty.AbstractExecutorAwareChannelPipelineFactory;
import org.apache.james.protocols.lib.netty.ConnectionCountHandler;
import org.apache.james.protocols.lib.netty.JMXEnabledOrderedMemoryAwareThreadPoolExecutor;
import org.apache.james.protocols.netty.AbstractAsyncServer;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.util.concurrent.JMXEnabledThreadPoolExecutor;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurableAsyncServer
extends AbstractAsyncServer
implements Configurable,
ServerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractConfigurableAsyncServer.class);
    public static final int DEFAULT_BACKLOG = 200;
    public static final int DEFAULT_TIMEOUT = 300;
    private static final String TIMEOUT_NAME = "connectiontimeout";
    private static final String BACKLOG_NAME = "connectionBacklog";
    public static final String HELLO_NAME = "helloName";
    public static final int DEFAULT_MAX_EXECUTOR_COUNT = 16;
    private static final String defaultX509algorithm = "SunX509";
    private String x509Algorithm = "SunX509";
    private FileSystem fileSystem;
    private HashedWheelTimer timer;
    private boolean enabled;
    protected int connPerIP;
    private boolean useStartTLS;
    private boolean useSSL;
    protected int connectionLimit;
    private String helloName;
    private String keystore;
    private String secret;
    private Encryption encryption;
    protected String jmxName;
    private String[] enabledCipherSuites;
    private final ConnectionCountHandler countHandler = new ConnectionCountHandler();
    private ExecutionHandler executionHandler = null;
    private ChannelHandlerFactory frameHandlerFactory;
    private int maxExecutorThreads;
    private MBeanServer mbeanServer;
    private int port;

    @Inject
    public final void setFileSystem(FileSystem filesystem) {
        this.fileSystem = filesystem;
    }

    @Inject
    public void setHashWheelTimer(HashedWheelTimer timer) {
        this.timer = timer;
    }

    protected void registerMBean() {
        try {
            this.mbeanServer.registerMBean(this, new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register mbean", e);
        }
    }

    protected void unregisterMBean() {
        try {
            this.mbeanServer.unregisterMBean(new ObjectName(this.getMBeanName()));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to unregister mbean", e);
        }
    }

    private String getMBeanName() {
        return "org.apache.james:type=server,name=" + this.jmxName;
    }

    public final void configure(HierarchicalConfiguration config) throws ConfigurationException {
        String connectionLimitPerIP;
        this.enabled = config.getBoolean("[@enabled]", true);
        if (!this.enabled) {
            LOGGER.info("{} disabled by configuration", (Object)this.getServiceType());
            return;
        }
        String[] listen = config.getString("bind", "0.0.0.0:" + this.getDefaultPort()).split(",");
        ArrayList<InetSocketAddress> bindAddresses = new ArrayList<InetSocketAddress>();
        for (String aListen : listen) {
            String[] bind = aListen.split(":");
            String ip = bind[0].trim();
            int port = Integer.parseInt(bind[1].trim());
            if (!ip.equals("0.0.0.0")) {
                try {
                    ip = InetAddress.getByName(ip).getHostName();
                }
                catch (UnknownHostException unhe) {
                    throw new ConfigurationException("Malformed bind parameter in configuration of service " + this.getServiceType(), (Throwable)unhe);
                }
            }
            InetSocketAddress address = new InetSocketAddress(ip, port);
            LOGGER.info("{} bound to: {}:{}", new Object[]{this.getServiceType(), ip, port});
            bindAddresses.add(address);
        }
        this.setListenAddresses(bindAddresses.toArray(new InetSocketAddress[bindAddresses.size()]));
        this.jmxName = config.getString("jmxName", this.getDefaultJMXName());
        int ioWorker = config.getInt("ioWorkerCount", DEFAULT_IO_WORKER_COUNT);
        this.setIoWorkerCount(ioWorker);
        this.maxExecutorThreads = config.getInt("maxExecutorCount", 16);
        this.configureHelloName((Configuration)config);
        this.setTimeout(config.getInt(TIMEOUT_NAME, 300));
        LOGGER.info("{} handler connection timeout is: {}", (Object)this.getServiceType(), (Object)this.getTimeout());
        this.setBacklog(config.getInt(BACKLOG_NAME, 200));
        LOGGER.info("{} connection backlog is: {}", (Object)this.getServiceType(), (Object)this.getBacklog());
        String connectionLimitString = config.getString("connectionLimit", null);
        if (connectionLimitString != null) {
            try {
                this.connectionLimit = new Integer(connectionLimitString);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("Connection limit value is not properly formatted.", (Throwable)nfe);
            }
            if (this.connectionLimit < 0) {
                LOGGER.error("Connection limit value cannot be less than zero.");
                throw new ConfigurationException("Connection limit value cannot be less than zero.");
            }
            if (this.connectionLimit > 0) {
                LOGGER.info("{} will allow a maximum of {} connections.", (Object)this.getServiceType(), (Object)connectionLimitString);
            }
        }
        if ((connectionLimitPerIP = config.getString("connectionLimitPerIP", null)) != null) {
            try {
                this.connPerIP = Integer.parseInt(connectionLimitPerIP);
            }
            catch (NumberFormatException nfe) {
                LOGGER.error("Connection limit per IP value is not properly formatted.", (Throwable)nfe);
            }
            if (this.connPerIP < 0) {
                LOGGER.error("Connection limit per IP value cannot be less than zero.");
                throw new ConfigurationException("Connection limit value cannot be less than zero.");
            }
            if (this.connPerIP > 0) {
                LOGGER.info("{} will allow a maximum of {} per IP connections for {}", new Object[]{this.getServiceType(), this.connPerIP, this.getServiceType()});
            }
        }
        this.useStartTLS = config.getBoolean("tls.[@startTLS]", false);
        this.useSSL = config.getBoolean("tls.[@socketTLS]", false);
        if (this.useSSL && this.useStartTLS) {
            throw new ConfigurationException("startTLS is only supported when using plain sockets");
        }
        if (this.useStartTLS || this.useSSL) {
            this.enabledCipherSuites = config.getStringArray("tls.supportedCipherSuites.cipherSuite");
            this.keystore = config.getString("tls.keystore", null);
            if (this.keystore == null) {
                throw new ConfigurationException("keystore needs to get configured");
            }
            this.secret = config.getString("tls.secret", "");
            this.x509Algorithm = config.getString("tls.algorithm", defaultX509algorithm);
        }
        this.doConfigure(config);
    }

    @PostConstruct
    public final void init() throws Exception {
        if (this.isEnabled()) {
            this.buildSSLContext();
            this.preInit();
            this.executionHandler = this.createExecutionHander();
            this.frameHandlerFactory = this.createFrameHandlerFactory();
            this.bind();
            this.port = this.retrieveFirstBindedPort();
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
            this.registerMBean();
            LOGGER.info("Init {} done", (Object)this.getServiceType());
        }
    }

    private int retrieveFirstBindedPort() {
        List listenAddresses = this.getListenAddresses();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)listenAddresses.get(0);
        return inetSocketAddress.getPort();
    }

    public int getPort() {
        return this.port;
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    @PreDestroy
    public final void destroy() {
        LOGGER.info("Dispose {}", (Object)this.getServiceType());
        if (this.isEnabled()) {
            this.unbind();
            this.postDestroy();
            if (this.executionHandler != null) {
                this.executionHandler.releaseExternalResources();
            }
            this.unregisterMBean();
        }
        LOGGER.info("Dispose {} done", (Object)this.getServiceType());
    }

    protected void postDestroy() {
    }

    protected void preInit() throws Exception {
    }

    protected void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
    }

    protected FileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected void configureHelloName(Configuration handlerConfiguration) throws ConfigurationException {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ue) {
            hostName = "localhost";
        }
        LOGGER.info("{} is running on: {}", (Object)this.getServiceType(), (Object)hostName);
        boolean autodetect = handlerConfiguration.getBoolean("helloName.[@autodetect]", true);
        if (autodetect) {
            this.helloName = hostName;
        } else {
            this.helloName = handlerConfiguration.getString(HELLO_NAME);
            if (this.helloName == null || this.helloName.trim().length() < 1) {
                throw new ConfigurationException("Please configure the helloName or use autodetect");
            }
        }
        LOGGER.info("{} handler hello name is: {}", (Object)this.getServiceType(), (Object)this.helloName);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public String getHelloName() {
        return this.helloName;
    }

    protected Encryption getEncryption() {
        return this.encryption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSSLContext() throws Exception {
        if (this.useStartTLS || this.useSSL) {
            try (FileInputStream fis = null;){
                KeyStore ks = KeyStore.getInstance("JKS");
                fis = new FileInputStream(this.fileSystem.getFile(this.keystore));
                ks.load(fis, this.secret.toCharArray());
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.x509Algorithm);
                kmf.init(ks, this.secret.toCharArray());
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(kmf.getKeyManagers(), null, null);
                this.encryption = this.useStartTLS ? Encryption.createStartTls((SSLContext)context, (String[])this.enabledCipherSuites) : Encryption.createTls((SSLContext)context, (String[])this.enabledCipherSuites);
            }
        }
    }

    protected abstract int getDefaultPort();

    @Override
    public String getSocketType() {
        if (this.encryption != null && !this.encryption.isStartTLS()) {
            return "secure";
        }
        return "plain";
    }

    @Override
    public boolean getStartTLSSupported() {
        return this.encryption != null && this.encryption.isStartTLS();
    }

    @Override
    public int getMaximumConcurrentConnections() {
        return this.connectionLimit;
    }

    protected String getThreadPoolJMXPath() {
        return "org.apache.james:type=server,name=" + this.jmxName + ",sub-type=threadpool";
    }

    protected Executor createBossExecutor() {
        return JMXEnabledThreadPoolExecutor.newCachedThreadPool((String)this.getThreadPoolJMXPath(), (String)(this.getDefaultJMXName() + "-boss"));
    }

    protected Executor createWorkerExecutor() {
        return JMXEnabledThreadPoolExecutor.newCachedThreadPool((String)this.getThreadPoolJMXPath(), (String)(this.getDefaultJMXName() + "-worker"));
    }

    protected abstract String getDefaultJMXName();

    protected String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public boolean isStarted() {
        return this.isBound();
    }

    @Override
    public boolean start() {
        try {
            this.bind();
        }
        catch (Exception e) {
            LOGGER.error("Unable to start server", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean stop() {
        this.unbind();
        return true;
    }

    @Override
    public long getHandledConnections() {
        return this.countHandler.getConnectionsTillStartup();
    }

    @Override
    public int getCurrentConnections() {
        return this.countHandler.getCurrentConnectionCount();
    }

    protected ConnectionCountHandler getConnectionCountHandler() {
        return this.countHandler;
    }

    @Override
    public String[] getBoundAddresses() {
        List addresses = this.getListenAddresses();
        String[] addrs = new String[addresses.size()];
        for (int i = 0; i < addresses.size(); ++i) {
            InetSocketAddress address = (InetSocketAddress)addresses.get(i);
            addrs[i] = address.getHostName() + ":" + address.getPort();
        }
        return addrs;
    }

    protected void configureBootstrap(ServerBootstrap bootstrap) {
        super.configureBootstrap(bootstrap);
        bootstrap.setOption("child.keepAlive", (Object)true);
    }

    protected ExecutionHandler createExecutionHander() {
        return new ExecutionHandler((Executor)((Object)new JMXEnabledOrderedMemoryAwareThreadPoolExecutor(this.maxExecutorThreads, 0L, 0L, this.getThreadPoolJMXPath(), this.getDefaultJMXName() + "-executor")));
    }

    protected abstract ChannelHandlerFactory createFrameHandlerFactory();

    protected ExecutionHandler getExecutionHandler() {
        return this.executionHandler;
    }

    protected ChannelHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    protected abstract ChannelUpstreamHandler createCoreHandler();

    protected ChannelPipelineFactory createPipelineFactory(ChannelGroup group) {
        return new AbstractExecutorAwareChannelPipelineFactory(this.getTimeout(), this.connectionLimit, this.connPerIP, group, this.enabledCipherSuites, this.getExecutionHandler(), this.getFrameHandlerFactory(), this.timer){

            protected SSLContext getSSLContext() {
                if (AbstractConfigurableAsyncServer.this.encryption == null) {
                    return null;
                }
                return AbstractConfigurableAsyncServer.this.encryption.getContext();
            }

            protected boolean isSSLSocket() {
                return AbstractConfigurableAsyncServer.this.encryption != null && !AbstractConfigurableAsyncServer.this.encryption.isStartTLS();
            }

            protected ChannelUpstreamHandler createHandler() {
                return AbstractConfigurableAsyncServer.this.createCoreHandler();
            }

            @Override
            protected ConnectionCountHandler getConnectionCountHandler() {
                return AbstractConfigurableAsyncServer.this.getConnectionCountHandler();
            }
        };
    }
}

