/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail.model.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxUtil;

public class SimpleMailbox
implements Mailbox {
    private MailboxId id = null;
    private String namespace;
    private String user;
    private String name;
    private final long uidValidity;
    private MailboxACL acl = MailboxACL.EMPTY;

    public SimpleMailbox(MailboxPath path, long uidValidity, MailboxId mailboxId) {
        this.id = mailboxId;
        this.namespace = path.getNamespace();
        this.user = path.getUser();
        this.name = path.getName();
        this.uidValidity = uidValidity;
    }

    public SimpleMailbox(MailboxPath path, long uidValidity) {
        this(path, uidValidity, null);
    }

    public SimpleMailbox(Mailbox mailbox) {
        this.id = mailbox.getMailboxId();
        this.namespace = mailbox.getNamespace();
        this.user = mailbox.getUser();
        this.name = mailbox.getName();
        this.uidValidity = mailbox.getUidValidity();
        this.acl = new MailboxACL(mailbox.getACL().getEntries());
    }

    @Override
    public MailboxId getMailboxId() {
        return this.id;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getUidValidity() {
        return this.uidValidity;
    }

    @Override
    public MailboxPath generateAssociatedPath() {
        return new MailboxPath(this.getNamespace(), this.getUser(), this.getName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof SimpleMailbox) {
            SimpleMailbox o = (SimpleMailbox)obj;
            return Objects.equal((Object)this.id, (Object)o.getMailboxId());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.namespace, this.user, this.name});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.namespace).add("user", (Object)this.user).add("name", (Object)this.name).toString();
    }

    @Override
    public void setMailboxId(MailboxId id) {
        this.id = id;
    }

    @Override
    public MailboxACL getACL() {
        return this.acl;
    }

    @Override
    public void setACL(MailboxACL acl) {
        this.acl = acl;
    }

    @Override
    public boolean isChildOf(Mailbox potentialParent, MailboxSession mailboxSession) {
        return MailboxUtil.isMailboxChildOf(this, potentialParent, mailboxSession);
    }
}

