/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.mail;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import javax.mail.Flags;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.ModSeqProvider;
import org.apache.james.mailbox.store.mail.UidProvider;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.james.mailbox.store.transaction.TransactionalMapper;

public abstract class AbstractMessageMapper
extends TransactionalMapper
implements MessageMapper {
    public static final int UNLIMITED = -1;
    protected final MailboxSession mailboxSession;
    private final UidProvider uidProvider;
    private final ModSeqProvider modSeqProvider;

    public AbstractMessageMapper(MailboxSession mailboxSession, UidProvider uidProvider, ModSeqProvider modSeqProvider) {
        this.mailboxSession = mailboxSession;
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
    }

    @Override
    public long getHighestModSeq(Mailbox mailbox) throws MailboxException {
        return this.modSeqProvider.highestModSeq(this.mailboxSession, mailbox);
    }

    @Override
    public Optional<MessageUid> getLastUid(Mailbox mailbox) throws MailboxException {
        return this.uidProvider.lastUid(this.mailboxSession, mailbox);
    }

    @Override
    public MailboxCounters getMailboxCounters(Mailbox mailbox) throws MailboxException {
        return MailboxCounters.builder().count(this.countMessagesInMailbox(mailbox)).unseen(this.countUnseenMessagesInMailbox(mailbox)).build();
    }

    @Override
    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange set) throws MailboxException {
        ArrayList<UpdatedFlags> updatedFlags = new ArrayList<UpdatedFlags>();
        Iterator<MailboxMessage> messages = this.findInMailbox(mailbox, set, MessageMapper.FetchType.Metadata, -1);
        long modSeq = -1L;
        if (messages.hasNext() && this.modSeqProvider != null) {
            modSeq = this.modSeqProvider.nextModSeq(this.mailboxSession, mailbox);
        }
        while (messages.hasNext()) {
            MailboxMessage member = messages.next();
            Flags originalFlags = member.createFlags();
            member.setFlags(flagsUpdateCalculator.buildNewFlags(originalFlags));
            Flags newFlags = member.createFlags();
            if (UpdatedFlags.flagsChanged((Flags)originalFlags, (Flags)newFlags)) {
                member.setModSeq(modSeq);
                this.save(mailbox, member);
            }
            updatedFlags.add(UpdatedFlags.builder().uid(member.getUid()).modSeq(member.getModSeq()).newFlags(newFlags).oldFlags(originalFlags).build());
        }
        return updatedFlags.iterator();
    }

    @Override
    public MessageMetaData add(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        message.setUid(this.uidProvider.nextUid(this.mailboxSession, mailbox));
        if (this.modSeqProvider != null) {
            message.setModSeq(this.modSeqProvider.nextModSeq(this.mailboxSession, mailbox));
        }
        MessageMetaData data = this.save(mailbox, message);
        return data;
    }

    @Override
    public MessageMetaData copy(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        MessageUid uid = this.uidProvider.nextUid(this.mailboxSession, mailbox);
        long modSeq = -1L;
        if (this.modSeqProvider != null) {
            modSeq = this.modSeqProvider.nextModSeq(this.mailboxSession, mailbox);
        }
        MessageMetaData metaData = this.copy(mailbox, uid, modSeq, original);
        return metaData;
    }

    protected abstract MessageMetaData save(Mailbox var1, MailboxMessage var2) throws MailboxException;

    protected abstract MessageMetaData copy(Mailbox var1, MessageUid var2, long var3, MailboxMessage var5) throws MailboxException;

    @Override
    public Iterator<MessageUid> listAllMessageUids(Mailbox mailbox) throws MailboxException {
        return Iterators.transform(this.findInMailbox(mailbox, MessageRange.all(), MessageMapper.FetchType.Metadata, -1), MailboxMessage::getUid);
    }
}

