/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json.event.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.mail.Flags;

public class FlagsDataTransferObject {
    @JsonProperty
    private boolean answered;
    @JsonProperty
    private boolean flagged;
    @JsonProperty
    private boolean recent;
    @JsonProperty
    private boolean deleted;
    @JsonProperty
    private boolean draft;
    @JsonProperty
    private boolean seen;
    @JsonProperty
    private String[] userFlags;

    public FlagsDataTransferObject() {
    }

    public FlagsDataTransferObject(Flags flags) {
        this.answered = flags.contains(Flags.Flag.ANSWERED);
        this.flagged = flags.contains(Flags.Flag.FLAGGED);
        this.recent = flags.contains(Flags.Flag.RECENT);
        this.deleted = flags.contains(Flags.Flag.DELETED);
        this.draft = flags.contains(Flags.Flag.DRAFT);
        this.seen = flags.contains(Flags.Flag.SEEN);
        this.userFlags = flags.getUserFlags();
    }

    @JsonIgnore
    public Flags getFlags() {
        Flags result = new Flags();
        if (this.answered) {
            result.add(Flags.Flag.ANSWERED);
        }
        if (this.flagged) {
            result.add(Flags.Flag.FLAGGED);
        }
        if (this.recent) {
            result.add(Flags.Flag.RECENT);
        }
        if (this.deleted) {
            result.add(Flags.Flag.DELETED);
        }
        if (this.draft) {
            result.add(Flags.Flag.DRAFT);
        }
        if (this.seen) {
            result.add(Flags.Flag.SEEN);
        }
        for (String flag : this.userFlags) {
            result.add(flag);
        }
        return result;
    }
}

