/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json.event.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.store.json.event.dto.EventType;
import org.apache.james.mailbox.store.json.event.dto.MailboxDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.MailboxPathDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.MailboxSessionDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.MessageMetaDataDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.UpdatedFlagsDataTransferObject;

public class EventDataTransferObject {
    @JsonProperty
    private EventType type;
    @JsonProperty
    private MailboxDataTransferObject mailbox;
    @JsonProperty
    private MailboxSessionDataTransferObject session;
    @JsonProperty
    private List<MessageUid> uids;
    @JsonProperty
    private Map<MessageUid, MessageMetaDataDataTransferObject> metaData;
    @JsonProperty
    private List<UpdatedFlagsDataTransferObject> updatedFlags;
    @JsonProperty
    private MailboxPathDataTransferObject from;
    @JsonProperty
    private Optional<QuotaRoot> quotaRoot;
    @JsonProperty
    private Optional<QuotaCount> deletedMessageCount;
    @JsonProperty
    private Optional<QuotaSize> totalDeletedSize;

    public static Builder builder() {
        return new Builder();
    }

    public EventDataTransferObject() {
    }

    public EventDataTransferObject(EventType type, MailboxDataTransferObject mailbox, MailboxSessionDataTransferObject session, List<MessageUid> uids, Map<MessageUid, MessageMetaDataDataTransferObject> metaData, List<UpdatedFlagsDataTransferObject> updatedFlags, MailboxPathDataTransferObject from, Optional<QuotaRoot> quotaRoot, Optional<QuotaCount> deletedMessageCount, Optional<QuotaSize> totalDeletedSize) {
        this.type = type;
        this.mailbox = mailbox;
        this.session = session;
        this.uids = uids;
        this.metaData = metaData;
        this.updatedFlags = updatedFlags;
        this.from = from;
        this.quotaRoot = quotaRoot;
        this.deletedMessageCount = deletedMessageCount;
        this.totalDeletedSize = totalDeletedSize;
    }

    @JsonIgnore
    public EventType getType() {
        return this.type;
    }

    @JsonIgnore
    public MailboxDataTransferObject getMailbox() {
        return this.mailbox;
    }

    @JsonIgnore
    public MailboxSessionDataTransferObject getSession() {
        return this.session;
    }

    @JsonIgnore
    public List<MessageUid> getUids() {
        return this.uids;
    }

    @JsonIgnore
    public Map<MessageUid, MessageMetaDataDataTransferObject> getMetaDataProxyMap() {
        return this.metaData;
    }

    @JsonIgnore
    public List<UpdatedFlagsDataTransferObject> getUpdatedFlags() {
        return this.updatedFlags;
    }

    @JsonIgnore
    public MailboxPathDataTransferObject getFrom() {
        return this.from;
    }

    @JsonIgnore
    public Optional<QuotaRoot> getQuotaRoot() {
        return this.quotaRoot;
    }

    @JsonIgnore
    public Optional<QuotaCount> getDeletedMessageCount() {
        return this.deletedMessageCount;
    }

    @JsonIgnore
    public Optional<QuotaSize> getTotalDeletedSize() {
        return this.totalDeletedSize;
    }

    public static class Builder {
        private EventType type;
        private MailboxDataTransferObject mailbox;
        private MailboxSessionDataTransferObject session;
        private List<MessageUid> uids;
        private Map<MessageUid, MessageMetaDataDataTransferObject> metaData;
        private List<UpdatedFlagsDataTransferObject> updatedFlags;
        private MailboxPathDataTransferObject from;
        private Optional<QuotaRoot> quotaRoot;
        private Optional<QuotaCount> deletedMessageCount;
        private Optional<QuotaSize> totalDeletedSize;

        public Builder type(EventType type) {
            this.type = type;
            return this;
        }

        public Builder mailbox(MailboxDataTransferObject mailbox) {
            this.mailbox = mailbox;
            return this;
        }

        public Builder session(MailboxSessionDataTransferObject session) {
            this.session = session;
            return this;
        }

        public Builder from(MailboxPathDataTransferObject from) {
            this.from = from;
            return this;
        }

        public Builder uids(List<MessageUid> uids) {
            this.uids = uids;
            return this;
        }

        public Builder metaData(Map<MessageUid, MessageMetaDataDataTransferObject> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder updatedFlags(List<UpdatedFlagsDataTransferObject> updatedFlagsList) {
            this.updatedFlags = updatedFlagsList;
            return this;
        }

        public Builder quotaRoot(Optional<QuotaRoot> quotaRoot) {
            this.quotaRoot = quotaRoot;
            return this;
        }

        public Builder deletedMessageCount(Optional<QuotaCount> deletedMessageCount) {
            this.deletedMessageCount = deletedMessageCount;
            return this;
        }

        public Builder totalDeletedSize(Optional<QuotaSize> totalDeletedSize) {
            this.totalDeletedSize = totalDeletedSize;
            return this;
        }

        public EventDataTransferObject build() {
            return new EventDataTransferObject(this.type, this.mailbox, this.session, this.uids, this.metaData, this.updatedFlags, this.from, this.quotaRoot, this.deletedMessageCount, this.totalDeletedSize);
        }
    }
}

