/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json.event;

import com.github.steveash.guavate.Guavate;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.event.EventFactory;
import org.apache.james.mailbox.store.json.event.EventNotValidException;
import org.apache.james.mailbox.store.json.event.MailboxConverter;
import org.apache.james.mailbox.store.json.event.dto.EventDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.EventType;
import org.apache.james.mailbox.store.json.event.dto.MailboxDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.MailboxPathDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.MailboxSessionDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.MessageMetaDataDataTransferObject;
import org.apache.james.mailbox.store.json.event.dto.UpdatedFlagsDataTransferObject;
import org.apache.james.mailbox.store.mail.model.Mailbox;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConverter {
    private static final Logger LOG = LoggerFactory.getLogger(EventConverter.class);
    private final EventFactory eventFactory = new EventFactory();
    private final MailboxConverter mailboxConverter;

    public EventConverter(MailboxConverter mailboxConverter) {
        this.mailboxConverter = mailboxConverter;
    }

    public EventDataTransferObject convertToDataTransferObject(MailboxListener.MailboxEvent event) throws Exception {
        MailboxDataTransferObject mailboxDataTransferObject = this.mailboxConverter.extractMailboxDataTransferObject(event);
        if (event instanceof MailboxListener.Added) {
            return this.constructMeteDataHoldingEventProxy(EventType.ADDED, event.getSession(), mailboxDataTransferObject, ((MailboxListener.Added)event).getUids(), (MailboxListener.MetaDataHoldingEvent)((MailboxListener.Added)event));
        }
        if (event instanceof MailboxListener.Expunged) {
            return this.constructMeteDataHoldingEventProxy(EventType.DELETED, event.getSession(), mailboxDataTransferObject, ((MailboxListener.Expunged)event).getUids(), (MailboxListener.MetaDataHoldingEvent)((MailboxListener.Expunged)event));
        }
        if (event instanceof MailboxListener.FlagsUpdated) {
            return this.constructFalgsUpdatedProxy(event.getSession(), mailboxDataTransferObject, ((MailboxListener.FlagsUpdated)event).getUids(), ((MailboxListener.FlagsUpdated)event).getUpdatedFlags());
        }
        if (event instanceof MailboxListener.MailboxRenamed) {
            return this.constructMailboxRenamedProxy(event.getSession(), mailboxDataTransferObject, event.getMailboxPath());
        }
        if (event instanceof MailboxListener.MailboxDeletion) {
            MailboxListener.MailboxDeletion deletionEvent = (MailboxListener.MailboxDeletion)event;
            return this.constructMailboxDeletionProxy(EventType.MAILBOX_DELETED, event.getSession(), mailboxDataTransferObject, deletionEvent.getQuotaRoot(), deletionEvent.getDeletedMessageCount(), deletionEvent.getTotalDeletedSize());
        }
        if (event instanceof MailboxListener.MailboxAdded) {
            return this.constructMailboxAddedProxy(EventType.MAILBOX_ADDED, event.getSession(), mailboxDataTransferObject);
        }
        throw new Exception("You are trying to serialize an event that can't be serialized");
    }

    public MailboxListener.MailboxEvent retrieveEvent(EventDataTransferObject eventDataTransferObject) throws Exception {
        Mailbox mailbox = this.mailboxConverter.retrieveMailbox(eventDataTransferObject.getMailbox());
        switch (eventDataTransferObject.getType()) {
            case ADDED: {
                return this.eventFactory.added(eventDataTransferObject.getSession().getMailboxSession(), this.retrieveMetadata(eventDataTransferObject.getMetaDataProxyMap()), mailbox, (Map<MessageUid, MailboxMessage>)ImmutableMap.of());
            }
            case DELETED: {
                return this.eventFactory.expunged(eventDataTransferObject.getSession().getMailboxSession(), this.retrieveMetadata(eventDataTransferObject.getMetaDataProxyMap()), mailbox);
            }
            case FLAGS: {
                return this.eventFactory.flagsUpdated(eventDataTransferObject.getSession().getMailboxSession(), eventDataTransferObject.getUids(), mailbox, this.retrieveUpdatedFlags(eventDataTransferObject.getUpdatedFlags()));
            }
            case MAILBOX_ADDED: {
                return this.eventFactory.mailboxAdded(eventDataTransferObject.getSession().getMailboxSession(), mailbox);
            }
            case MAILBOX_DELETED: {
                return this.eventFactory.mailboxDeleted(eventDataTransferObject.getSession().getMailboxSession(), mailbox, eventDataTransferObject.getQuotaRoot().orElseThrow(() -> new EventNotValidException("Not a Deletion event, missing quotaRoot")), eventDataTransferObject.getDeletedMessageCount().orElseThrow(() -> new EventNotValidException("Not a Deletion event, missing quotaCount")), eventDataTransferObject.getTotalDeletedSize().orElseThrow(() -> new EventNotValidException("Not a Deletion event, missing quotaSize")));
            }
            case MAILBOX_RENAMED: {
                return this.eventFactory.mailboxRenamed(eventDataTransferObject.getSession().getMailboxSession(), eventDataTransferObject.getFrom().getPath(), mailbox);
            }
        }
        throw new Exception("Can not deserialize unknown event");
    }

    private EventDataTransferObject constructMailboxAddedProxy(EventType eventType, MailboxSession mailboxSession, MailboxDataTransferObject mailboxIntermediate) {
        return EventDataTransferObject.builder().type(eventType).session(new MailboxSessionDataTransferObject(mailboxSession)).mailbox(mailboxIntermediate).build();
    }

    private EventDataTransferObject constructMailboxDeletionProxy(EventType eventType, MailboxSession mailboxSession, MailboxDataTransferObject mailboxIntermediate, QuotaRoot quotaRoot, QuotaCount deletedMessageCount, QuotaSize totalDeletedSize) {
        return EventDataTransferObject.builder().type(eventType).session(new MailboxSessionDataTransferObject(mailboxSession)).mailbox(mailboxIntermediate).quotaRoot(Optional.of(quotaRoot)).deletedMessageCount(Optional.of(deletedMessageCount)).totalDeletedSize(Optional.of(totalDeletedSize)).build();
    }

    private EventDataTransferObject constructMailboxRenamedProxy(MailboxSession mailboxSession, MailboxDataTransferObject mailboxIntermediate, MailboxPath from) {
        return EventDataTransferObject.builder().type(EventType.MAILBOX_RENAMED).session(new MailboxSessionDataTransferObject(mailboxSession)).mailbox(mailboxIntermediate).from(new MailboxPathDataTransferObject(from)).build();
    }

    private EventDataTransferObject constructFalgsUpdatedProxy(MailboxSession session, MailboxDataTransferObject mailboxIntermediate, List<MessageUid> uids, List<UpdatedFlags> updatedFlagsList) {
        List updatedFlagsDataTransferObjects = (List)updatedFlagsList.stream().map(UpdatedFlagsDataTransferObject::new).collect(Guavate.toImmutableList());
        return EventDataTransferObject.builder().type(EventType.FLAGS).session(new MailboxSessionDataTransferObject(session)).mailbox(mailboxIntermediate).uids(uids).updatedFlags(updatedFlagsDataTransferObjects).build();
    }

    private EventDataTransferObject constructMeteDataHoldingEventProxy(EventType eventType, MailboxSession mailboxSession, MailboxDataTransferObject mailboxIntermediate, List<MessageUid> uids, MailboxListener.MetaDataHoldingEvent event) {
        HashMap<MessageUid, MessageMetaDataDataTransferObject> metaDataProxyMap = new HashMap<MessageUid, MessageMetaDataDataTransferObject>();
        for (MessageUid uid : uids) {
            metaDataProxyMap.put(uid, new MessageMetaDataDataTransferObject(event.getMetaData(uid)));
        }
        return EventDataTransferObject.builder().type(eventType).session(new MailboxSessionDataTransferObject(mailboxSession)).mailbox(mailboxIntermediate).uids(uids).metaData(metaDataProxyMap).build();
    }

    private SortedMap<MessageUid, MessageMetaData> retrieveMetadata(Map<MessageUid, MessageMetaDataDataTransferObject> metaDataProxyMap) {
        if (metaDataProxyMap != null) {
            TreeMap<MessageUid, MessageMetaData> result = new TreeMap<MessageUid, MessageMetaData>();
            Set<Map.Entry<MessageUid, MessageMetaDataDataTransferObject>> entrySet = metaDataProxyMap.entrySet();
            for (Map.Entry<MessageUid, MessageMetaDataDataTransferObject> entry : entrySet) {
                result.put(entry.getKey(), entry.getValue().getMetadata());
            }
            return result;
        }
        LOG.warn("Event serialization problem : No metadata");
        return null;
    }

    private List<UpdatedFlags> retrieveUpdatedFlags(List<UpdatedFlagsDataTransferObject> updatedFlagsDataTransferObject) {
        return (List)updatedFlagsDataTransferObject.stream().map(UpdatedFlagsDataTransferObject::retrieveUpdatedFlags).collect(Guavate.toImmutableList());
    }
}

