/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.github.fge.lambdas.Throwing;
import java.io.IOException;
import java.util.Optional;
import org.apache.james.core.Domain;
import org.apache.james.core.quota.QuotaCount;
import org.apache.james.core.quota.QuotaSize;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.store.event.EventSerializer;
import org.apache.james.mailbox.store.json.event.EventConverter;
import org.apache.james.mailbox.store.json.event.dto.EventDataTransferObject;

public class JacksonEventSerializer
implements EventSerializer {
    private final EventConverter eventConverter;
    private final ObjectMapper objectMapper;
    private static final String QUOTA_ROOT_VALUE_FIELD = "value";
    private static final String QUOTA_ROOT_DOMAIN_FIELD = "domain";

    public JacksonEventSerializer(EventConverter eventConverter, ObjectMapper objectMapper) {
        this.eventConverter = eventConverter;
        this.objectMapper = objectMapper;
    }

    @Override
    public byte[] serializeEvent(MailboxListener.MailboxEvent event) throws Exception {
        return this.objectMapper.writeValueAsBytes((Object)this.eventConverter.convertToDataTransferObject(event));
    }

    @Override
    public MailboxListener.MailboxEvent deSerializeEvent(byte[] serializedEvent) throws Exception {
        EventDataTransferObject eventDataTransferObject = (EventDataTransferObject)this.objectMapper.readValue(serializedEvent, EventDataTransferObject.class);
        return this.eventConverter.retrieveEvent(eventDataTransferObject);
    }

    public static ObjectMapper configureObjectMapper(ObjectMapper objectMapper, MessageId.Factory messageIdFactory) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(MessageUid.class, (JsonDeserializer)new MessageUidDeserializer());
        module.addKeyDeserializer(MessageUid.class, (KeyDeserializer)new MessageUidKeyDeserializer());
        module.addSerializer(MessageUid.class, (JsonSerializer)new MessageUidSerializer());
        module.addKeySerializer(MessageUid.class, (JsonSerializer)new MessageUidKeySerializer());
        module.addSerializer(MessageId.class, (JsonSerializer)new MessageIdSerializer());
        module.addDeserializer(MessageId.class, (JsonDeserializer)new MessageIdDeserializer(messageIdFactory));
        module.addSerializer(QuotaRoot.class, (JsonSerializer)new QuotaRootSerializer());
        module.addDeserializer(QuotaRoot.class, (JsonDeserializer)new QuotaRootDeserializer());
        module.addSerializer(QuotaCount.class, (JsonSerializer)new QuotaCountSerializer());
        module.addDeserializer(QuotaCount.class, (JsonDeserializer)new QuotaCountDeserializer());
        module.addSerializer(QuotaSize.class, (JsonSerializer)new QuotaSizeSerializer());
        module.addDeserializer(QuotaSize.class, (JsonDeserializer)new QuotaSizeDeserializer());
        objectMapper.registerModules(new Module[]{module, new Jdk8Module()});
        return objectMapper;
    }

    public static class QuotaSizeDeserializer
    extends JsonDeserializer<QuotaSize> {
        public QuotaSize deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            return QuotaSize.size((long)parser.getLongValue());
        }
    }

    public static class QuotaSizeSerializer
    extends JsonSerializer<QuotaSize> {
        public void serialize(QuotaSize value, JsonGenerator generator, SerializerProvider serializers) throws IOException, JsonProcessingException {
            generator.writeNumber(value.asLong());
        }
    }

    public static class QuotaCountDeserializer
    extends JsonDeserializer<QuotaCount> {
        public QuotaCount deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            return QuotaCount.count((long)parser.getLongValue());
        }
    }

    public static class QuotaCountSerializer
    extends JsonSerializer<QuotaCount> {
        public void serialize(QuotaCount value, JsonGenerator generator, SerializerProvider serializers) throws IOException, JsonProcessingException {
            generator.writeNumber(value.asLong());
        }
    }

    public static class QuotaRootDeserializer
    extends JsonDeserializer<QuotaRoot> {
        public QuotaRoot deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            ObjectCodec codec = parser.getCodec();
            TreeNode node = codec.readTree(parser);
            return QuotaRoot.quotaRoot((String)this.value(node), this.domain(node));
        }

        private String value(TreeNode node) throws IOException, JsonParseException {
            TextNode value = (TextNode)node.get(JacksonEventSerializer.QUOTA_ROOT_VALUE_FIELD);
            return value.asText();
        }

        private Optional<Domain> domain(TreeNode node) throws IOException, JsonParseException {
            TreeNode value = node.get(JacksonEventSerializer.QUOTA_ROOT_DOMAIN_FIELD);
            if (value == null || value.isMissingNode()) {
                return Optional.empty();
            }
            return Optional.ofNullable(node.asToken().asString()).map(Domain::of);
        }
    }

    public static class QuotaRootSerializer
    extends JsonSerializer<QuotaRoot> {
        public void serialize(QuotaRoot value, JsonGenerator generator, SerializerProvider serializers) throws IOException, JsonProcessingException {
            generator.writeStartObject();
            generator.writeStringField(JacksonEventSerializer.QUOTA_ROOT_VALUE_FIELD, value.getValue());
            value.getDomain().ifPresent(Throwing.consumer(domain -> generator.writeStringField(JacksonEventSerializer.QUOTA_ROOT_DOMAIN_FIELD, domain.asString())));
            generator.writeEndObject();
        }
    }

    public static class MessageIdDeserializer
    extends JsonDeserializer<MessageId> {
        private final MessageId.Factory factory;

        public MessageIdDeserializer(MessageId.Factory factory) {
            this.factory = factory;
        }

        public MessageId deserialize(JsonParser p, DeserializationContext context) throws IOException, JsonProcessingException {
            return this.factory.fromString(p.getValueAsString());
        }
    }

    public static class MessageIdSerializer
    extends JsonSerializer<MessageId> {
        public void serialize(MessageId value, JsonGenerator generator, SerializerProvider serializers) throws IOException, JsonProcessingException {
            generator.writeString(String.valueOf(value.serialize()));
        }
    }

    public static class MessageUidKeySerializer
    extends JsonSerializer<MessageUid> {
        public void serialize(MessageUid value, JsonGenerator generator, SerializerProvider serializers) throws IOException, JsonProcessingException {
            generator.writeFieldName(String.valueOf(value.asLong()));
        }
    }

    public static class MessageUidKeyDeserializer
    extends KeyDeserializer {
        public Object deserializeKey(String key, DeserializationContext context) throws IOException, JsonProcessingException {
            return MessageUid.of((long)Long.parseLong(key));
        }
    }

    public static class MessageUidSerializer
    extends JsonSerializer<MessageUid> {
        public void serialize(MessageUid value, JsonGenerator generator, SerializerProvider serializers) throws IOException, JsonProcessingException {
            generator.writeString(String.valueOf(value.asLong()));
        }
    }

    public static class MessageUidDeserializer
    extends JsonDeserializer<MessageUid> {
        public MessageUid deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            return MessageUid.of((long)Long.parseLong(parser.getValueAsString()));
        }
    }
}

