/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import javax.inject.Inject;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.store.event.EventDelivery;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronousEventDelivery
implements EventDelivery {
    private static final Logger LOGGER = LoggerFactory.getLogger(SynchronousEventDelivery.class);
    private final MetricFactory metricFactory;

    @Inject
    public SynchronousEventDelivery(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliver(MailboxListener mailboxListener, Event event) {
        TimeMetric timer = this.metricFactory.timer("mailbox-listener-" + mailboxListener.getClass().getSimpleName());
        try {
            mailboxListener.event(event);
        }
        catch (Throwable throwable) {
            LOGGER.error("Error while processing listener {} for {}", new Object[]{mailboxListener.getClass().getCanonicalName(), event.getClass().getCanonicalName(), throwable});
        }
        finally {
            timer.stopAndPublish();
        }
    }
}

