/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store.event;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.apache.james.mailbox.Event;
import org.apache.james.mailbox.MailboxListener;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.event.DelegatingMailboxListener;
import org.apache.james.mailbox.store.event.EventDelivery;
import org.apache.james.mailbox.store.event.MailboxListenerRegistry;
import org.apache.james.mailbox.store.event.SynchronousEventDelivery;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopMetricFactory;

public class DefaultDelegatingMailboxListener
implements DelegatingMailboxListener {
    private final MailboxListenerRegistry registry;
    private final EventDelivery eventDelivery;

    public MailboxListener.ListenerType getType() {
        return MailboxListener.ListenerType.EACH_NODE;
    }

    @VisibleForTesting
    public DefaultDelegatingMailboxListener() {
        this(new SynchronousEventDelivery((MetricFactory)new NoopMetricFactory()), new MailboxListenerRegistry());
    }

    @Inject
    public DefaultDelegatingMailboxListener(EventDelivery eventDelivery, MailboxListenerRegistry registry) {
        this.registry = registry;
        this.eventDelivery = eventDelivery;
    }

    public void addListener(MailboxPath path, MailboxListener listener, MailboxSession session) throws MailboxException {
        if (listener.getType() != MailboxListener.ListenerType.MAILBOX) {
            throw new MailboxException(listener.getClass().getCanonicalName() + " registred on specific MAILBOX operation while its listener type was " + listener.getType());
        }
        this.registry.addListener(path, listener);
    }

    public void addGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        if (listener.getType() != MailboxListener.ListenerType.EACH_NODE && listener.getType() != MailboxListener.ListenerType.ONCE) {
            throw new MailboxException(listener.getClass().getCanonicalName() + " registered on global event dispatching while its listener type was " + listener.getType());
        }
        this.registry.addGlobalListener(listener);
    }

    public void removeListener(MailboxPath mailboxPath, MailboxListener listener, MailboxSession session) throws MailboxException {
        this.registry.removeListener(mailboxPath, listener);
    }

    public void removeGlobalListener(MailboxListener listener, MailboxSession session) throws MailboxException {
        this.registry.removeGlobalListener(listener);
    }

    public void event(Event event) {
        this.deliverEventToGlobalListeners(event);
        if (event instanceof MailboxListener.MailboxEvent) {
            this.mailboxEvent((MailboxListener.MailboxEvent)event);
        }
    }

    private void mailboxEvent(MailboxListener.MailboxEvent mailboxEvent) {
        List<MailboxListener> listenerSnapshot = this.registry.getLocalMailboxListeners(mailboxEvent.getMailboxPath());
        if (mailboxEvent instanceof MailboxListener.MailboxDeletion && listenerSnapshot.size() > 0) {
            this.registry.deleteRegistryFor(mailboxEvent.getMailboxPath());
        } else if (mailboxEvent instanceof MailboxListener.MailboxRenamed && listenerSnapshot.size() > 0) {
            MailboxListener.MailboxRenamed renamed = (MailboxListener.MailboxRenamed)mailboxEvent;
            this.registry.handleRename(renamed.getMailboxPath(), renamed.getNewPath());
        }
        this.deliverEventToMailboxListeners(mailboxEvent, listenerSnapshot);
    }

    protected void deliverEventToMailboxListeners(MailboxListener.MailboxEvent event, Collection<MailboxListener> listenerSnapshot) {
        for (MailboxListener listener : listenerSnapshot) {
            this.eventDelivery.deliver(listener, (Event)event);
        }
    }

    protected void deliverEventToGlobalListeners(Event event) {
        for (MailboxListener mailboxListener : this.registry.getGlobalListeners()) {
            this.eventDelivery.deliver(mailboxListener, event);
        }
    }

    public MailboxListenerRegistry getRegistry() {
        return this.registry;
    }
}

