/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.mail.Flags;
import org.apache.james.core.User;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.MailboxACLResolver;
import org.apache.james.mailbox.exception.DifferentDomainException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.store.MailboxSessionMapperFactory;
import org.apache.james.mailbox.store.event.MailboxEventDispatcher;
import org.apache.james.mailbox.store.mail.MailboxMapper;
import org.apache.james.mailbox.store.mail.model.Mailbox;

public class StoreRightManager
implements RightManager {
    public static final boolean GROUP_FOLDER = true;
    private final MailboxEventDispatcher dispatcher;
    private final MailboxSessionMapperFactory mailboxSessionMapperFactory;
    private final MailboxACLResolver aclResolver;
    private final GroupMembershipResolver groupMembershipResolver;

    @Inject
    public StoreRightManager(MailboxSessionMapperFactory mailboxSessionMapperFactory, MailboxACLResolver aclResolver, GroupMembershipResolver groupMembershipResolver, MailboxEventDispatcher dispatcher) {
        this.mailboxSessionMapperFactory = mailboxSessionMapperFactory;
        this.aclResolver = aclResolver;
        this.groupMembershipResolver = groupMembershipResolver;
        this.dispatcher = dispatcher;
    }

    public boolean hasRight(MailboxPath mailboxPath, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.myRights(mailboxPath, session).contains(right);
    }

    public boolean hasRight(MailboxId mailboxId, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.myRights(mailboxId, session).contains(right);
    }

    public boolean hasRight(Mailbox mailbox, MailboxACL.Right right, MailboxSession session) throws MailboxException {
        return this.myRights(mailbox, session).contains(right);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        return this.myRights(mailbox, session);
    }

    public MailboxACL.Rfc4314Rights myRights(MailboxId mailboxId, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxById(mailboxId);
        return this.myRights(mailbox, session);
    }

    public MailboxACL.Rfc4314Rights myRights(Mailbox mailbox, MailboxSession session) throws UnsupportedRightException {
        MailboxSession.User user = session.getUser();
        return Optional.ofNullable(user).map(Throwing.function(value -> this.aclResolver.resolveRights(user.getUserName(), this.groupMembershipResolver, mailbox.getACL(), mailbox.getUser(), false)).sneakyThrow()).orElse(MailboxACL.NO_RIGHTS);
    }

    public MailboxACL.Rfc4314Rights[] listRights(MailboxPath mailboxPath, MailboxACL.EntryKey key, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        return this.aclResolver.listRights(key, this.groupMembershipResolver, mailbox.getUser(), false);
    }

    public MailboxACL listRights(MailboxPath mailboxPath, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        return mailbox.getACL();
    }

    public void applyRightsCommand(MailboxPath mailboxPath, MailboxACL.ACLCommand mailboxACLCommand, MailboxSession session) throws MailboxException {
        this.assertSharesBelongsToUserDomain(mailboxPath.getUser(), mailboxACLCommand);
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        ACLDiff aclDiff = mapper.updateACL(mailbox, mailboxACLCommand);
        this.dispatcher.aclUpdated(session, mailboxPath, aclDiff);
    }

    private void assertSharesBelongsToUserDomain(String user, MailboxACL.ACLCommand mailboxACLCommand) throws DifferentDomainException {
        this.assertSharesBelongsToUserDomain(user, (Map<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights>)ImmutableMap.of((Object)mailboxACLCommand.getEntryKey(), (Object)mailboxACLCommand.getRights()));
    }

    public boolean isReadWrite(MailboxSession session, Mailbox mailbox, Flags sharedPermanentFlags) throws UnsupportedRightException {
        MailboxACL.Rfc4314Rights rights = this.myRights(mailbox, session);
        return rights.contains(MailboxACL.Right.Insert) || rights.contains(MailboxACL.Right.PerformExpunge) || this.checkDeleteFlag(rights, sharedPermanentFlags) || this.checkSeenFlag(rights, sharedPermanentFlags) || this.checkWriteFlag(rights, sharedPermanentFlags);
    }

    private boolean checkWriteFlag(MailboxACL.Rfc4314Rights rights, Flags sharedPermanentFlags) {
        return rights.contains(MailboxACL.Right.Write) && (sharedPermanentFlags.contains(Flags.Flag.ANSWERED) || sharedPermanentFlags.contains(Flags.Flag.DRAFT) || sharedPermanentFlags.contains(Flags.Flag.FLAGGED) || sharedPermanentFlags.contains(Flags.Flag.RECENT) || sharedPermanentFlags.contains(Flags.Flag.USER));
    }

    private boolean checkSeenFlag(MailboxACL.Rfc4314Rights rights, Flags sharedPermanentFlags) {
        return sharedPermanentFlags.contains(Flags.Flag.SEEN) && rights.contains(MailboxACL.Right.WriteSeenFlag);
    }

    private boolean checkDeleteFlag(MailboxACL.Rfc4314Rights rights, Flags sharedPermanentFlags) {
        return sharedPermanentFlags.contains(Flags.Flag.DELETED) && rights.contains(MailboxACL.Right.DeleteMessages);
    }

    public void setRights(MailboxId mailboxId, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxById(mailboxId);
        this.setRights(mailbox.generateAssociatedPath(), mailboxACL, session);
    }

    public void setRights(MailboxPath mailboxPath, MailboxACL mailboxACL, MailboxSession session) throws MailboxException {
        this.assertSharesBelongsToUserDomain(mailboxPath.getUser(), mailboxACL.getEntries());
        MailboxMapper mapper = this.mailboxSessionMapperFactory.getMailboxMapper(session);
        Mailbox mailbox = mapper.findMailboxByPath(mailboxPath);
        this.setRights(mailboxACL, mapper, mailbox, session);
    }

    @VisibleForTesting
    void assertSharesBelongsToUserDomain(String user, Map<MailboxACL.EntryKey, MailboxACL.Rfc4314Rights> entries) throws DifferentDomainException {
        if (entries.keySet().stream().filter(entry -> !entry.getNameType().equals((Object)MailboxACL.NameType.special)).map(MailboxACL.EntryKey::getName).anyMatch(name -> this.areDomainsDifferent((String)name, user))) {
            throw new DifferentDomainException();
        }
    }

    @VisibleForTesting
    boolean areDomainsDifferent(String user, String otherUser) {
        Optional otherDomain;
        Optional domain = User.fromUsername((String)user).getDomainPart();
        return !domain.equals(otherDomain = User.fromUsername((String)otherUser).getDomainPart());
    }

    private void setRights(MailboxACL mailboxACL, MailboxMapper mapper, Mailbox mailbox, MailboxSession session) throws MailboxException {
        ACLDiff aclDiff = mapper.setACL(mailbox, mailboxACL);
        this.dispatcher.aclUpdated(session, mailbox.generateAssociatedPath(), aclDiff);
    }

    public MailboxACL getResolvedMailboxACL(Mailbox mailbox, MailboxSession mailboxSession) throws UnsupportedRightException {
        MailboxACL acl = this.aclResolver.applyGlobalACL(mailbox.getACL(), false);
        return StoreRightManager.filteredForSession(mailbox, acl, mailboxSession);
    }

    @VisibleForTesting
    static MailboxACL filteredForSession(Mailbox mailbox, MailboxACL acl, MailboxSession mailboxSession) throws UnsupportedRightException {
        if (mailbox.generateAssociatedPath().belongsTo(mailboxSession)) {
            return acl;
        }
        MailboxACL.EntryKey userAsKey = MailboxACL.EntryKey.createUserEntryKey((String)mailboxSession.getUser().getUserName());
        MailboxACL.Rfc4314Rights rights = acl.getEntries().getOrDefault(userAsKey, new MailboxACL.Rfc4314Rights(new MailboxACL.Right[0]));
        if (rights.contains(MailboxACL.Right.Administer)) {
            return acl;
        }
        return new MailboxACL((Map)ImmutableMap.of((Object)userAsKey, (Object)rights));
    }
}

