/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.store;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.AttachmentManager;
import org.apache.james.mailbox.BlobManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.exception.AttachmentNotFoundException;
import org.apache.james.mailbox.exception.BlobNotFoundException;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.Blob;
import org.apache.james.mailbox.model.BlobId;
import org.apache.james.mailbox.model.FetchGroupImpl;
import org.apache.james.mailbox.model.MessageId;

public class StoreBlobManager
implements BlobManager {
    public static final String MESSAGE_RFC822_CONTENT_TYPE = "message/rfc822";
    private final AttachmentManager attachmentManager;
    private final MessageIdManager messageIdManager;
    private final MessageId.Factory messageIdFactory;

    @Inject
    public StoreBlobManager(AttachmentManager attachmentManager, MessageIdManager messageIdManager, MessageId.Factory messageIdFactory) {
        this.attachmentManager = attachmentManager;
        this.messageIdManager = messageIdManager;
        this.messageIdFactory = messageIdFactory;
    }

    public BlobId toBlobId(MessageId messageId) {
        return BlobId.fromString((String)messageId.serialize());
    }

    public Blob retrieve(BlobId blobId, MailboxSession mailboxSession) throws MailboxException, BlobNotFoundException {
        return this.getBlobFromAttachment(blobId, mailboxSession).orElseGet(() -> this.getBlobFromMessage(blobId, mailboxSession).orElseThrow(() -> new BlobNotFoundException(blobId)));
    }

    private Optional<Blob> getBlobFromAttachment(BlobId blobId, MailboxSession mailboxSession) throws MailboxException {
        try {
            AttachmentId attachmentId = AttachmentId.from((BlobId)blobId);
            return Optional.of(this.attachmentManager.getAttachment(attachmentId, mailboxSession).toBlob());
        }
        catch (AttachmentNotFoundException e) {
            return Optional.empty();
        }
    }

    private Optional<Blob> getBlobFromMessage(BlobId blobId, MailboxSession mailboxSession) {
        return this.retrieveMessageId(blobId).flatMap(messageId -> this.loadMessageAsBlob((MessageId)messageId, mailboxSession)).map(Throwing.function(blob -> Blob.builder().id(blobId).contentType(MESSAGE_RFC822_CONTENT_TYPE).payload(IOUtils.toByteArray((InputStream)blob)).build()));
    }

    private Optional<MessageId> retrieveMessageId(BlobId blobId) {
        try {
            return Optional.of(this.messageIdFactory.fromString(blobId.asString()));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private Optional<InputStream> loadMessageAsBlob(MessageId messageId, MailboxSession mailboxSession) {
        try {
            return this.messageIdManager.getMessages((List)ImmutableList.of((Object)messageId), FetchGroupImpl.FULL_CONTENT, mailboxSession).stream().map(Throwing.function(message -> message.getFullContent().getInputStream())).findFirst();
        }
        catch (MailboxException e) {
            throw new RuntimeException(e);
        }
    }
}

